#include <iostream>

using namespace std;

template <typename T>
class Stack {
private:
	////////////////////////////////////////////////////////
	// Dades i estructures de dades privades a la classe. //
	////////////////////////////////////////////////////////
	
	struct Item {
		T value;
		Item* next;
	};

	int _size;
	Item* ptopitem;

	////////////////////////////////////////////////////////
	// Funcions auxiliars privades a la classe.           //
	////////////////////////////////////////////////////////
	
	Item* copyItems(Item *pitem);
	
	void deleteItems();
	
	void printRec(ostream &os, const Item *pitem) const;
	
public:
	////////////////////////////////////////////////////////
	// Constructors de la classe. 						  //
	////////////////////////////////////////////////////////

	Stack();
	
	Stack(const Stack<T> &s);
	
	~Stack();

	////////////////////////////////////////////////////////
	// Operador d'assignació de la classe.				  //
	////////////////////////////////////////////////////////
	
	Stack<T> &operator=(const Stack<T> &s);

	////////////////////////////////////////////////////////
	// Funcions estàndards de la classe.		          //
	////////////////////////////////////////////////////////
	
	int size() const;

	bool empty() const;

	void push(T value);
	
	void pop();
		
	T top() const;

	////////////////////////////////////////////////////////
	// Entrada / Sortida de la classe.				      //
	////////////////////////////////////////////////////////
	
	void print(ostream &os) const;
	
	void read(istream &is);
	
		
	////////////////////////////////////////////////////////
	// Mètode removeDuplicates                             		  //
	////////////////////////////////////////////////////////
	void removeDuplicates();

};	
/* ----------- FINAL DE LA CLASSE STACK ------------ */


////////////////////////////////////////////////////////
// Implementació de la classe Stack.	              //
////////////////////////////////////////////////////////

/* ----------- MÈTODES PRIVATS ------------ */

template <typename T>
typename Stack<T>::Item* Stack<T>::copyItems(Item *pitem) {
	Item *pfirstitem = nullptr;
	if (pitem != nullptr) {
		pfirstitem = new Item();
		Item *pcurrentitem = pfirstitem;
		while (pitem != nullptr) {
			pcurrentitem->value = pitem->value;
			if (pitem->next != nullptr) pcurrentitem->next = new Item();
			else pcurrentitem->next = nullptr;
			pcurrentitem = pcurrentitem->next;
			pitem = pitem->next;
		}
	}
	return pfirstitem;
}
	

template <typename T>
void Stack<T>::deleteItems() {
	Item *pitem = ptopitem;
	while (pitem != nullptr) {
		Item *pitemaux = pitem;
		pitem = pitem->next;
		delete pitemaux;
	}
	_size = 0;
	ptopitem = nullptr;
}
	
template <typename T>
void Stack<T>::printRec(ostream &os, const Item *pitem) const {
	if (pitem != nullptr) {
		printRec(os, pitem->next);
		if (pitem->next != nullptr) os << " ";
		os << pitem->value;
	}
}

	
/* ----------- MÈTODES PÚBLICS ------------ */

////////////////////////////////////////////////////////
// Constructors de la classe.				          //
////////////////////////////////////////////////////////

template <typename T>
Stack<T>::Stack() {
	ptopitem = nullptr;
	_size = 0;
}
	
template <typename T>
Stack<T>::Stack(const Stack<T> &s) {
	ptopitem = copyItems(s.ptopitem);
	_size = s._size;
}
	
template <typename T>
Stack<T>::~Stack() {
	deleteItems();
}

////////////////////////////////////////////////////////
// Operador d'assignació de la classe.				  //
////////////////////////////////////////////////////////
	
template <typename T>
Stack<T>& Stack<T>::operator=(const Stack<T> &s) {
	if (this != &s) {
		deleteItems();
		ptopitem = copyItems(s.ptopitem);
		_size = s._size;
	}		
	return *this;
}

////////////////////////////////////////////////////////
// Funcions estàndards de la classe.				  //
////////////////////////////////////////////////////////
	
template <typename T>
int Stack<T>::size() const {
	return _size;
}

template <typename T>
bool Stack<T>::empty() const {
	return ptopitem == nullptr;
}

template <typename T>
void Stack<T>::push(T value) {
	Item *pnewitem = new Item();
	pnewitem->value = value;
	pnewitem->next = ptopitem;
	ptopitem = pnewitem;
	++_size;
}
	
template <typename T>
void Stack<T>::pop() {
	if (ptopitem == nullptr) {
		cerr << "Error: pop on empty stack" << endl;
		exit(1);
	}
		
	Item *paux = ptopitem;
	ptopitem = ptopitem->next;
	delete paux;
	--_size;
}
		
template <typename T>
T Stack<T>::top() const {
	if (ptopitem == nullptr) {
		cerr << "Error: accessing top of empty stack" << endl;
		exit(1);
	}		
	return ptopitem->value;
}

////////////////////////////////////////////////////////
// Implementació de l'entrada/sortida.				  //
////////////////////////////////////////////////////////

template <typename T>
void Stack<T>::read(istream &is) {
	deleteItems();
	unsigned int num;
	is >> num;
	for (int i = 0; i < num; ++i) {
		T value;
		is >> value;
		push(value);
	}
} 

template <typename T> 
void Stack<T>::print(ostream &os) const {
	os << _size;
	if (ptopitem != nullptr) os << " ";
	printRec(os, ptopitem);
}

template <typename U> 
ostream &operator<<(ostream &os, const Stack<U> &s) {
	s.print(os);
	return os;
}

template <typename U> 
istream &operator>>(istream &is, Stack<U> &s) {
	s.read(is);
	return is;
}

/* ------- FINAL DE LA IMPLEMENTACIÓ ENTRADA/SORTIDA -------- */

// Pre:	cert.
// Post: Esborra del p.i. els elements de la pila que estan
//   duplicats mantenint la primera aparició de cada element
//   (els que estan més a dalt de la pila).
template <typename T>
void Stack<T>::removeDuplicates() {
	// Mètode que has d'implementar
	
}
