# Arbres quasi coincidents

Donats dos arbres binaris, **a**, **b** d'elements de qualsevol tipus,
diem que són *quasi coincidents* si per a tot node d'**a** existeix un
node de **b** a la mateixa posició i viceversa, tret d'un node com a
màxim.

Volem una operació que ens permeti saber si dos arbres són quasi
coincidents. Feu servir la següent especificació:

    bool quasi_coincidents (Arbre<int> &a, Arbre<int> &b)
    /* Pre: a=A, b=B */
    /* Post: el resultat indica si A i B son quasi coincidents */

Exemple: considereu els quatre arbres següents

    a =    7           b =    4           c =   10           d =   -4      
        /     \            /     \            /     \            /     \   
       6      -2          9       6         -1      -2          6      -2  
      / \     / \        / \     / \        /       / \        / \     /  
    -2  -3  -1   3     -1   3   8  -3     -2      -1   3     -1   3   8   
                                   /
                                  1

- $(a,b)$ són quasi coincidents (només hi ha un node que no correspon,
  l'1); també ho són $(a,c)$ i $(a,d)$

- $(c,d)$ no són quasi coincidents (hi ha dos nodes que no corresponen,
  el 3 de $c$ i el 3 de $d$); tampoc ho són $(b,c)$ i $(b,d)$

## Entrada

L'entrada són dos arbres.

## Sortida

La sortida és un booleà indicant si els dos arbres són quasi
coincidents.

## Observació

Només s'ha d'enviar un fitxer que contengui la funció amb la capçalera
de l'enunciat i qualsevol altra funció auxiliar que cregueu convenient,
sense la funció main. Afegiu-hi també l'include de la classe Arbre
mitjançant

#include \"Arbre.hh\"

## Informació del problema

Autoria: Alberto Moreno (adaptador), Ramon Ferrer i Cancho (responsable)

Generació: 2026-01-25T17:27:41.286Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
