from sys import stdin

class Llista:

    # ----------------------------------------------------
    # Classe interna per definir els elements de la llista:
    # Cada element de la llista serà una instància de _Node
    class _Node:
        __slots__ = '_element','_next','_prev' # opcional, per eficiència
        
        def __init__(self, prev, next, element=None): 
            self._element = element            # ref. a l'element emmagatzemat
            self._next = next                  # referència al proper node
            self._prev = prev                  # referència al node anterior 
    # ----------------------------------------------------
            
    def __init__(self):
        self.__sentinella = self._Node(None,None)   # _Node sentinella
        self.__sentinella._next = self.__sentinella
        self.__sentinella._prev = self.__sentinella
        self.__cursor   = self.__sentinella
        self.__n        = 0                    # nombre d'elements (sense sentinella!)

    def mida(self):                         
        return self.__n

    def buida(self):
        return self.__n == 0

    # Comprova si el cursor és al principi
    # de la llista 
    def is_at_front(self):
        return self.__cursor == self.__sentinella._next
  
    # Comprova si el cursor és al final
    # de la llista    
    def is_at_end(self):
        return self.__cursor == self.__sentinella

    # Mou el cursor una posició enrere
    def move_backward(self):
        # Pre: el cursor NO està al començament
        assert not self.is_at_front() 
        self.__cursor = self.__cursor._prev

    # Mou el cursor una posició endavant   
    def move_forward(self):
        # Pre: el cursor NO està al final
        assert not self.is_at_end()
        self.__cursor = self.__cursor._next

    # Mou el cursor al principi de la llista
    def move_to_front(self):
        self.__cursor = self.__sentinella._next

    # Mou el cursor al final de la llista 
    def move_to_end(self):
        self.__cursor = self.__sentinella # !!!

    # Retorna l'element referenciat pel cursor
    def front(self):
        # Pre: el cursor NO està al final
        assert not self.is_at_end()
        return self.__cursor._element

    # Insereix l'element x abans del cursor
    def insert(self, x):
        p = self._Node(self.__cursor._prev, self.__cursor, x)
        self.__cursor._prev._next = p
        self.__cursor._prev = p
        self.__n += 1
        return self

    # Elimina l'element ref. pel cursor
    # i avança el cursor una posició
    def erase(self):
        # Pre: el cursor NO està al final
        assert not self.is_at_end()
        p = self.__cursor
        p._next._prev = p._prev
        p._prev._next = p._next
        self.__cursor = p._next
        self.__n -= 1

    # Mètode que, DESTRUCTIVAMENT, inverteix la llista
    def reverse(self):
        if not self.buida():
            to_change = self.__sentinella
            # simulo un do...while
            next_to_change = to_change._next
            to_change._prev, to_change._next = to_change._next, to_change._prev
            to_change = next_to_change
            while not to_change == self.__sentinella:
                next_to_change = to_change._next
                to_change._prev, to_change._next = to_change._next, to_change._prev
                to_change = next_to_change

    def __str__(self):
        s = ''
        p = self.__sentinella._next
        while p != self.__sentinella:
            s += ' -- ' + str(p._element)
            p = p._next
        return s

    def transform(self, f):
        l = Llista()
        p = self.__sentinella._next
        while (p != self.__sentinella):   # Visit all elements and apply f to each one
            l.insert(f(p._element))     
            p = p._next
        return l

    def filter(self, f):
        l = Llista()
        p = self.__sentinella._next
        while (p != self.__sentinella): # Pick elements only if f is asserted
           if f(p._element):
               l.insert(p._element)
           p = p._next
        return l

    def reduce(self, x0, f):
        x = x0
        p = self.__sentinella._next
        while (p != self.__sentinella):
            x = f(x, p._element)       
            p = p._next
        return x

    def __iter__(self):
        self.move_to_front()
        return self

    def __next__(self):
        if self.is_at_end():
            raise StopIteration
        else:
            resultat = self.front()
            self.move_forward()
            return resultat


lists = dict()
for line in stdin:
    if line.startswith("d"):
        "define a list"
        line = line.split()
        lists[line[1]] = Llista()
        for e in line[2:]:
            lists[line[1]].insert(int(e))
    elif line.startswith("i"):
        "intersect two lists"
        line = line.split()
        a = lists[line[1]]
        b = lists[line[2]]
        c = interseccio(a, b)
        print(line[1], line[2], c)
