# Afegir mètodes += i -= als iteradors de la classe llista

Modifiqueu la classe List per tal d'afegir els operadors `+=` i `-=` a
la subclasse iterador. Aquests mètodes reben un enter, i desplacen
l'iterador cap endavant i cap enrere, respectivament, tantes posicions
com indica aquest enter. Noteu que, si l'enter és negatiu, `+=` mourà
l'iterador cap enrere, i `-=` mourà l'iterador cap endavant. S'assumeix
que els paràmetres no fan que l'iterador se surti del rang de la llista.

D'entre els fitxers que s'adjunten en aquest exercici, trobareu
`list.old.hpp`, a on hi ha una implementació de la classe genèrica
`List`. En primer lloc, haureu de fer:

    cp list.old.hpp list.hpp

A continuació, haureu de buscar dins `list.hpp` les següents línies:

    // Pre: x és un enter tal que, si desplacem l'iterador implícit x unitats cap endavant
    //      (que implicarà moure'l -x unitats cap enrere si x és negatiu), no se surt de rang.
    // Post: l'iterador implícit s'ha mogut x unitats cap endavant (cosa que haurà implicat
    //       moure'l -x unitats cap enrere en el cas que x sigui negatiu, o no moure'l si x és 0).
    // Descomenteu les següents dues linies i implementeu el mètode:
    // void operator+=(int x) {
    // }

    // Pre: x és un enter tal que, si desplacem l'iterador implícit x unitats cap enrere
    //      (que implicarà moure'l -x unitats cap endavant si x és negatiu), no se surt de rang.
    // Post: l'iterador implícit s'ha mogut x unitats cap enrere (cosa que haurà implicat
    //       moure'l -x unitats cap endavant en el cas que x sigui negatiu, o no moure'l si x és 0).
    // Descomenteu les següents dues linies i implementeu el mètode:
    // void operator-=(int x) {
    // }

Descomenteu les quatre linies que s'indiquen i implementeu els mètodes.
No toqueu la resta de la implementació de la classe, excepte si, per
algun motiu, considereu que necessiteu afegir algun mètode auxiliar a la
part privada.

D'entre els fitxers que s'adjunten a l'exercici també hi ha
`program.cpp` (programa principal) i `Makefile` per a compilar. Per a
pujar la vostra solució, heu de crear el fitxer `solution.tar` així:

    tar cf solution.tar list.hpp

## Entrada

La entrada del programa és una seqüència d'instruccions del següent
tipus que s'aniran aplicant sobre una llista que se suposa inicialment
buida i un iterador que se suposa situat inicialment al principi (i
final) d'aquesta llista:

    push_front s (s és un string)
    push_back s (s és un string)
    pop_front 
    pop_back
    it+= x (x és un enter)
    it-= x (x és un enter)
    *it

Se suposa que la seqüència d'entrada serà correcta (sense `pop_front` ni
`pop_back` sobre llista buida, ni `it` tenint `it` situat al `end` de la
llista). Tampoc hi haurà `pop_front` just quan l'iterador estigui
apuntant al primer element de la llista, ni hi haurà `pop_back` just
quan l'iterador estigui apuntant a l'últim element de la llista (tingueu
en compte que l'últim element de la llista no és el `end` de la llista).
A més a més, els paràmetres x són tals que l'iterador no se surt de
rang.

El programa principal que us oferim ja s'encarrega de llegir aquestes
entrades i fer les crides als corresponents mètodes de la classe list.
Només cal que implementeu els mètodes abans esmentats.

## Sortida

Per a cada instrucció `it`, s'escriurà el contingut apuntat per
l'iterador. El programa que us oferim ja fa això. Només cal que
implementeu el mètode abans esmentat.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T21:19:32.015Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
