# Chain of primes

You have to program the function \@has_prime_chain@ below. Remember that
a non negative integer $n$ is prime if and only if $n$ is greater than
one and the only divisors of $n$ are one and $n$. The following auxiliar
function may be helpful.

    def is_prime(n):
        '''
        Requires a non negative integer n.
        Returns True when n is prime 
        Returns False when n is not prime
        '''
        if  n < 2:
            return False
        d = 2
        while d*d <= n:
            if n%d == 0:
                return False
            d += 1
        return True

- Write a function \@has_prime_chain(f, k)@ that given a list $f$ of non
  negative integers and an integer $k$ greater than zero returns the
  first valid index of $f$ where a chain of primes of size $k$ starts.
  If there is no such valid index it has to return $-1$. A chain of
  primes is a block of consecutive numbers in the list all of them being
  prime, delimited by non prime numbers or the ends of the list.

## Scoring

The function counts 100 points.

## Sample session

## Problem information

Author: ProAl

Generation: 2026-01-25T17:20:50.542Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
