# TinyMicro datapath

Design the datapath of the TinyMicro. The datapath should be
parametrizable with the width of the data (DWIDTH) and the width of the
memory address (AWIDTH). Use the default values shown in the
specification.

## Specification

``` verilog
module datapath (Data_Address, ReadData, WriteData, Const, EnA, EnB, Op,
                 MemConst, MemAlu, Zero, Positive, clk, rst);
    parameter DWIDTH=6;
    parameter AWIDTH=4;
    output [AWIDTH-1:0] Data_Address;
    input [DWIDTH-1:0] ReadData;
    output [DWIDTH-1:0] WriteData;
    input [DWIDTH-1:0] Const;
    input [1:0] Op;
    input EnA, EnB, MemConst, MemAlu, clk, rst;
    output Zero, Positive;
```

## Input

- `ReadData` is the data coming from memory.

- `Const` is the constant coming from the control unit and encoded in
  the instruction register.

- `Op` is the ALU operation.

- `EnA` and `EnB` are the enable signals of registers RA and RB.

- `MemConst` is the signal that selects between `ReadData` (0) and
  `Const` (1).

- `MemAlu` is the signal that selects the value to be written to the
  registers between data coming from memory/constant (0) or from the ALU
  (1).

- `clk` is the clock signal of the circuit.

- `rst` is the reset signal of the circuit.

## Output

- `Data_Address` is the memory address.

- `WriteData` is the data to be written into memory.

- `Zero` indicates whether the value stored in RA is zero.

- `Positive` indicates whether the value stored in RA is positive.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:25:28.853Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
