# Perfect numbers

A proper divisor of a number is a positive factor of that number other
than the number itself. For example, the proper divisors of 6 are 1, 2,
and 3. A perfect number is a positive integer that is equal to the sum
of its proper positive divisors. For instance, $6 = 1 + 2 + 3$ and
$28 = 1 + 2 + 4 + 7 + 14$ are perfect numbers. In contrast, $1, 2, 3$
and $18$ are not perfect.

Write a function \@show_perfect(f)@ that given a list $f$ of integers
greater than zero computes the first perfect number that appears in $f$,
if any. When $f$ has no perfect numbers the function returns $-1$.

The following function \@proper_divisors(n)@ that computes the ordered
list of proper divisors of a natural number $n$ can be helpful.

    def proper_divisors(n):
        '''
        n is an integer greater than zero
        returns the ordered list of proper divsisors of n
        >>> proper_divisors(6)
        [1, 2, 3]
        >>> proper_divisors(284)
        [1, 2, 4, 71, 142]
        >>> proper_divisors(1)
        []
        '''
        if n == 1:
            return []
        result = [1]
        d = 2
        while d*d <= n:
            if n%d == 0:
                result.append(d)
                if n//d != d:
                    result.append(n//d)
            d += 1
        return sorted(result)

## Sample session

## Problem information

Author: ProAl

Generation: 2026-01-25T17:19:36.450Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
