# Suma màxima d'un camí entre dos nodes qualsevol de l'arbre binari

Implementeu una funció **RECURSIVA** que, donat un arbre binari
d'enters, obtingues la suma màxima d'un camí entre dos nodes qualsevol
de l'arbre binari. Aquesta és la capcelera:

    // Pre: t és un arbre binari no buit que conté nombres enters.
    // Post: Retorna la suma màxima possible d'un camí entre dos nodes
    //       qualsevol de l'arbre donat. El camí de suma màxima pot  
    //       passar o no per l'arrel. 
    int maxSumPath(BinaryTree<int> t);

Aquí teniu dos exemples d'entrada de la funció i les seves corresponents
sortides. El primer, el camí de suma màxima passa per l'arrel i el segon
no passa per l'arrel:

    2(4(7,6),5(3,4))
    =>
    22 -> 7+4+2+5+4
    1(1(2,3),5(9,9))
    =>
    23 -> 5+9+9

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar: `Makefile`, `program.cpp`,
`BinaryTree.hpp`, `maxSumPath.hpp`. Us falta crear el fitxer
`maxSumPath.cpp` amb els corresponents `includes` i implementar-hi la
funció anterior. Quan pugeu la vostra solució al JUTGE, només cal que
pugeu un **TAR** construït així:

    tar cf solution.tar maxSumPath.cpp

## Entrada

L'entrada té un nombre arbitrari de casos. Cada cas consisteix en una
línia amb un string describint un arbre binari d'enters. Fixeu-vos en
que el programa que us oferim ja s'encarrega de llegir aquestes
entrades. Només cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, cal escriure la suma màxima d'un camí entre dos nodes
qualsevol de l'arbre binari. Fixeu-vos en que el programa que us oferim
ja s'encarrega d'escriure aquesta sortida. Només cal que implementeu la
funció abans esmentada.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. En les
crides recursives, incloeu la hipòtesi d'inducció, és a dir una
explicació del que es cumpleix després de la crida, i també la funció de
fita/decreixement o una justificació de perquè la funció recursiva
acaba.

Una solució directa superarà els jocs de proves públics i us permetrà
obtenir una nota raonable. Però molt possiblement serà lenta, i
necessitareu crear alguna funció recursiva auxiliar per a produïr una
solució més eficient capaç de superar tots els jocs de proves.

Avaluació sobre 10 punts:

- Solució lenta: 7 punts.

- Solució lenta + justificació: 8 punts.

- solució ràpida: 9 punts.

- solució ràpida + justificació: 10 punts.

Entenem com a solució lenta una que és correcta i capaç de superar els
jocs de proves públics. Entenem com a solució ràpida una que és correcta
i capaç de superar els jocs de proves públics i privats. La justificació
val 1 punt i consisteix en definir correctament les PRE/POST de les
funcions auxiliars que afegiu i en definir correctament les hipòtesis
d'inducció i funcions de fita.

## Informació del problema

Autoria: STUDENTS PRO1

Generació: 2026-01-25T21:19:02.685Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
