# Cues quàntiques

En aquest exercici modificarem la classe `Queue` afegint dos nous
mètodes `entangle` i `disentangle` i canviant el comportament del mètode
`pop` com descrivim a continuació.

El nou mètode `entangle` rebrà una altra `Queue` com a paràmetre. Una
crida `q0.entangle(q1)` provocarà que `q0` quedi enllaçat a `q1` de
manera que, a partir de llavors, sempre que fem un `pop` sobre `q0`,
l'element extret serà afegit al final de `q1`. Una crida
`q0.disentangle()` cancel.larà aquest comportament.

Fixeu-vos en aquest exemple per tal d'acabar d'entendre-ho:

    Queue<string> q0, q1;
    q0.push("a");     // q0: a
    q0.push("b");     // q0: a,b
    q1.push("c");     // q1: c
    q1.push("d");     // q1: c,d
    q0.entangle(q1);
    q0.pop();         // q0: b  q1: c,d,a
    q1.pop();         // q0: b  q1: d,a
    q1.entangle(q0);
    q0.pop();         // q0:    q1: d,a,b
    q1.pop();         // q0: d  q1: a,b
    q0.disentangle();
    q0.pop();         // q0:    q1: a,b
    q1.pop();         // q0: a  q1: b
    q1.disentangle();
    q0.pop();         // q0:    q1: b
    q1.pop();         // q0:    q1:

Successius `entangle` fan que només l'últim estigui actiu. Per exemple,
si hem executat `q0.entangle(q1)` i després `q0.entangle(q2)`, llavors
`q0` està enllaçat a `q2` però no a `q1`.

Una crida `q0.disentangle()` cancel.larà l'efecte de l'últim `entangle`
actiu. En altres paraules, `q0` queda com a no enllaçat a cap altra cua.

D'entre els fitxers que s'adjunten en aquest exercici, trobareu
`queue.hh`, a on hi ha una implementació de la classe genèrica `Queue`.
Haureu d'implementar els dos nous mètodes `entangle` i `disentangle`
dins `queue.hh` a la part pública de la classe (podeu trobar les
capçaleres comentades dins `queue.hh`), i modificar el mètode `pop`
convenientment. Necessitareu també algun atribut addicional per tal de
recordar si la cua té un `entangle` actiu i amb qui, amb les convenients
inicialitzacions.

D'entre els fitxers que s'adjunten a l'exercici també hi ha `main.cc`
(programa principal), i el podeu compilar directament, doncs inclou
`queue.hh`. Només cal que pugeu `queue.hh` al jutge.

**Observació:** La solució ràpida de `pop` amb `entanglement` hauria de
moure punters i no pas valors.

**Observació:** En els jocs de proves no es copiaran cues. Per tant, no
cal que adapteu els mètodes que copien cues, de manera que no cal
decidir si l'entanglement d'una cua s'hereta sobre una còpia.

## Entrada

L'entrada del programa comença amb una declaració d'unes quantes cues
d'strings (`q0, q1, ...`), i després té una seqüència de comandes sobre
les cues declarades. Com que ja us oferim el `main.cc`, no cal que us
preocupeu d'implementar la lectura d'aquestes entrades. Només cal que
implementeu la extensió de la classe cua abans esmentada.

Podeu assumir que les comandes faran disentangles només sobre cues que
tinguin un entangle actiu. Però pot ser el cas que es faci un entangle
sobre una cua que ja tingui un entangle actiu. Com mencionavem abans, en
aquestes situacions només l'últim entangle aplica.

## Sortida

Per a cada comanda d'escriptura sobre la sortida s'escriurà el resultat
corresponent. El `main.cc` que us oferim ja fa això. Només cal que
implementeu la extensió de la classe cua abans esmentada.

## Observació

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, on la operació `pop`
amb `entanglement` té cost **CONSTANT** (fins i tot si els strings
involucrats son grans), i capaç de superar els jocs de proves públics i
privats. Entenem com a solució lenta una que no és ràpida, però és
correcta i capaç de superar els jocs de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-27T18:53:44.054Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
