

#include <iostream>    

void add_node(bst_node* root, bst_node* new_node)
{
    if (root->m_value > new_node->m_value)
    {
        if (root->m_left)
            return add_node(root->m_left, new_node);
        root->m_left = new_node;
        new_node->m_parent = root;
    }
    else
    {
        if (root->m_right)
            return add_node(root->m_right, new_node);
        root->m_right = new_node;
        new_node->m_parent = root;
    }
}

bst_node* next(bst_node* node);

int main () {
    int n;
    while (std::cin >> n)
    {
        bst_node* root = nullptr;
        
        for (int i = 0; i < n; ++i)
        {
            bst_node* node = new bst_node;
            std::cin >> node->m_value;
            if (i == 0)
                root = node;
            else
                add_node(root, node);
        }

        bst_node* first = root;
        while (first->m_left)
            first = first->m_left;

        while (first)
        {
            std::cout << first->m_value << std::endl;
            first = next(first);
        }
        std::cout << std::endl;
    }
}
