# Classe conjunt de parelles d'enters

Cal implementar la següent classe $cj\_2enters$ que ens permet
representar i manipular conjunts de parelles d'enters.

Dins del conjunt no importa l'ordre de les parelles i no poden haver-hi
parelles repetides. Dins de cada parella d'enters importa l'ordre dels
dos enters i es poden repetir els dos enters. Per exemple (els elements
del conjunt estan separats amb espais i la parella d'enters amb una
coma):

- Els conjunts \[1,1 3,1 1,2\] i \[3,1 1,2 1,1\] són el mateix

- Els conjunts \[1,2\] i \[2,1\] són diferents

<!-- -->

    class cj_2enters {
    public:

      // Constructora per defecte. Crea un conjunt buit.
      cj_2enters();

      // Les tres grans: Constructora per còpia, destructora, operador d'assignació
      cj_2enters(const cj_2enters &cj);
      ~cj_2enters();
      cj_2enters& operator=(const cj_2enters &cj);

      // Insereix la parella d'enters pe en el conjunt. No fa res si pe ja pertanyia al conjunt.
      void insereix(pair<int, int> pe);

      // Unió, intersecció i diferència de conjunts. Operen modificant el conjunt sobre el que
      // s’aplica el mètode, usant el segon conjunt com argument. P.e.: a.restar(b) fa que el
      // nou valor d’a sigui A - B, on A i B són els valors originals dels objectes a i b.
      void unir(const cj_2enters& B);
      void intersectar(const cj_2enters& B);
      void restar(const cj_2enters& B);

      // Unió, intersecció i diferència de conjunts. Operen creant un nou conjunt sense 
      // modificar el conjunt sobre el que s’aplica el mètode. La suma de conjunts correspon
      // a la unió, la resta a la diferència i el producte a la intersecció.
      cj_2enters operator+(const cj_2enters& B) const;
      cj_2enters operator*(const cj_2enters& B) const;
      cj_2enters operator-(const cj_2enters& B) const;

      // Retorna cert si i només si pe pertany al conjunt.
      bool conte(pair<int, int> pe) const;

      // Retornen els elements màxim i mínim del conjunt, respectivament.
      // El seu comportament no està definit si el conjunt és buit.
      // pe1 és major que pe2 si el 1er enter de pe1 és major que el 1er enter de pe2. En cas
      // que siguin iguals, si el 2on enter de pe1 és major que el 2on enter de pe2. 
      pair<int, int> max() const;
      pair<int, int> min() const;

      // Retorna el nombre d’elements (la cardinalitat) del conjunt.
      int card() const;

      // Operadors relacionals. == retorna cert si i només si els dos conjunts
      // (el paràmetre implícit i B) contenen els mateixos elements;
      // != retorna cert si i només si els conjunts són diferents.
      bool operator==(const cj_2enters& B) const;
      bool operator!=(const cj_2enters& B) const;

      // Imprimeix el conjunt de parelles d’enters, ordenats en ordre ascendent, sobre
      // el canal de sortida os; el format és [pe1 pe2 ... pen], és a dir, amb
      // espais entre els elements i tancant la seqüència amb corxets.
      // Els dos enters de la parella d'enters estan separats amb una coma.
      void print(ostream& os) const;

    private:
        // Cal definir els atributs i mètodes privats dins del fitxer .rep 
        #include "conjunt_2enters.rep"
    };

Bàsicament el que cal fer és:

1.  Trobar una representació adequada pels objectes de la classe i
    escriure els atributs necessaris en la part $private$ de la classe
    (dins del fitxer $conjunt\_2enters.rep$). També es poden especificar
    mètodes privats addicionals.

2.  Implementar tots els mètodes de la classe els quals manipularan la
    representació anterior dins del fitxer $conjunt\_2enters.cpp$.

Cal enviar la solució (els fitxers $conjunt\_2enters.rep$ i
$conjunt\_2enters.cpp$) comprimida en un sol fitxer $.tar$

Per testejar la classe disposes d'un programa principal que processa
blocs que contenen dos conjunts $A$ i $B$ i vàries comandes que els
manipulen.

## Entrada

L'entrada conté varis blocs separats per línies amb 10 guions
(-----------). Cada bloc consisteix en dues seqüències d'enters, una per
línia, cadascuna d'elles són els elements que tindran originalment el
conjunt $A$ i el conjunt $B$. A continuació segueixen vàries comandes,
una per línea, amb el següent format:

- insereix cjt1 e1 e2

- conte cjt1 e1 e2

- max cjt1

- min cjt1

- card cjt1

- unir cjt1 cjt2

- intersectar cjt1 cjt2

- restar cjt1 cjt2

- \+ cjt1 cjt2

- \* cjt1 cjt2

- \- cjt1 cjt2

- == cjt1 cjt2

- !=cjt1 cjt2

- print cjt1

On cjt1 i cjt2 poden ser 'A' o 'B' i e1 i e2 són enters.

## Sortida

Per a cada línia d'entrada, escriu una línia amb el resultat:

- Si la línia és un conjunt, mostra el conjunt un cop inserit tots els
  seus elements.

- Si la línia és una comanda, mostra la comanda, el separador \": \" i
  el resultat. Si la comanda retorna o modifica algun conjunt, mostra
  aquest conjunt.

- Si la línia és el separador de blocs format per 10 guions, mostra els
  mateixos 10 guions.

## Observació

Aquest problema proporciona la definició pública de la classe
$cj\_2enters$ dins del fitxer $conjunt\_2enters.hpp$, el programa
principal $main.cpp$ i un fitxer $Makefile$ per facilitar la compilació.

Per implementar el conjunt no es poden usar les classes $stack$,
$queue$, $list$ o $set$ de la STL.

Pots fer un parell de versions, una implementada amb memòria estàtica
(usant per exemple arrays de C++) i una altra implementada amb memòria
dinàmica. Si la versió amb memòria estàtica té un límit en el màxim
nombre d'element d'un conjunt, segurament no passarà els jocs de prova
privats on hi ha casos amb conjunts molt grans.

Si els mètodes d'unir, intersectar, restar, igualtat i diferència no es
programen de forma eficient (cost lineal) tampoc passaran els jocs de
prova privats degut a un excés de temps d'execució.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T21:17:42.275Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
