# Màxima suma d'un camí descendent.

**Preliminars**

Considereu el següent arbre binari de naturals positius:

        3 
       / \
      1   3
     / \   \
    4   5   6
         \
          2

Com podeu observar, hi ha tres fulles amb valors 4, 2 i 6. Si agafem el
camí descendent que ens porta des de l'arrel fins a la fulla amb un 4, i
anem sumant tots els valors que trobem pel camí, obtenim 3+1+4 = 8. En
canvi, si agafem en camí que ens porta des de l'arrel fins a la fulla
amb un 2, la suma és 3+1+5+2 = 11. Pel cas de la fulla amb un 6, la suma
obtinguda és 3+3+6 = 12. Per tant, 12 és la suma màxima que podem
obtenir en un camí descendent des de l'arrel fins a alguna fulla.

**Fi de preliminars**

Implementeu una funció **RECURSIVA** que, donat un arbre binari de
naturals positius, retorna la suma màxima que es pot obtenir sumant els
valors dels nodes que es troben en un camí descendent des de l'arrel
fins a alguna fulla. En el cas de l'exemple d'arbre anterior, el
resultat de la funció seria 12. Aquesta és la capçalera:

    /** 
     * @pre  t conté naturals positius en els seus nodes.
     * @post Retorna la suma màxima que es pot obtenir sumant els valors que 
     *       es troben en un camí descendent des de l'arrel fins a alguna fulla.
     */
    int maxSumDescPath(BinTree<int> t);

L'enunciat d'aquest exercici ja ofereix uns fitxers que haureu
d'utilitzar per a compilar: `main.cc, BinTree.hh, maxSumDescPath.hh`. Us
falta crear el fitxer `maxSumDescPath.cc` amb els corresponents
`includes` i implementar-hi la funció anterior. Només cal que pugeu
`maxSumDescPath.cc` al jutge.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé `INLINEFORMAT` o bé `VISUALFORMAT`. Després venen un
nombre arbitrari de casos. Cada cas consisteix en una descripció d'un
arbre binari d'enters. El programa que us oferim ja s'encarrega de
llegir aquestes entrades. Només cal que implementeu la funció abans
esmentada.

## Sortida

Per a cada cas, la sortida conté el corresponent resultat de cridar a la
funció. El programa que us oferim ja s'encarrega d'escriure aquest
resultat. Només cal que implementeu la funció `maxSumDescPath`.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
arbres. Heu de trobar una solució **RECURSIVA** del problema. Avaluació
sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost lineal i capaç
de superar els jocs de proves públics i privats. Entenem com a solució
lenta una que no és ràpida, però és correcta i capaç de superar els jocs
de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T17:07:04.621Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
