# Alta d'un alumne amb llista simplement encadenada amb fantasma

Donada la classe $Llista$ que permet guardar seqüències de $Strings$ amb
una llista simplement encadenada, **amb fantasma** i no circular, cal
implementar el mètode:

    void alumne_nou(string alumne_cercat, string alumne_nou)

El mètode cerca el alumne amb nom $nom\_cercat$ a la llista i insereix
l'alumne $nom\_nou$ a la posició immediatament posterior. Si no es troba
cap alumne amb nom $nom\_cercat$, el nou alumne va al final de la
llista. Els alumnes es representen amb $Strings$ que son el seu nom. No
tenim alumnes repetits a la llista.

Cal enviar a jutge.org només la implementació del mètode $alumne\_nou$.
La classe $Llista$ té la següent especificació:

    #include <vector>
    #include <cstddef>
    using namespace std;
    typedef unsigned int nat;

    class Llista {
      // Llista simplement encadenada, amb fantasma i no circular.
      private:
        struct node {
          string info;  // Informació del node
          node *seg; // Punter al següent element
        };
        node *_prim; // Punter a l'element fantasma
        nat _long;   // Nombre d'elements

      public:
        Llista();
        // Pre: True
        // Post: El p.i. és una llista buida.

        Llista(const vector<int> &v);
        // Pre: True
        // Post: El p.i. conté els elements de v amb el mateix ordre.

        ~Llista();
        // Post: Destrueix els elements del p.i.

        nat longitud() const;
        // Pre: True
        // Post: Retorna el nombre d'elements del p.i.

        void mostra() const;
        // Pre: True
        // Post: Mostra el p.i. pel canal estàndard de sortida.

        void alumne_nou(string alumne_cercat, string alumne_nou);
        // Pre: True
        // Post: Es dona d'alta l'alumne segons l'especificació del problema
    };

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Llista$ i un programa principal que processa
línies de $Strings$ amb els que crea la llista i desprès crida el mètode
$alumne\_nou$.

## Entrada

L'entrada conté vàries línies formades per $Strings$. Cadascuna d'elles
són els elements que tindrà la llista d'alumnes inicialment. Els
elements inicials de la llista venen delimitats per el $String$
\"Final\". A continuació, les dues darreres línies son l'alumne cercat i
el nou alumne respectivament.

## Sortida

Escriu una línia amb el resultat desprès d'haver donat d'alta l'alumne
nou, amb els noms dels alumnes separats per espais i delimitat per
claudàtors tal com fa la funció $mostra$ de la classe $Llista$.

## Observació

Cal enviar la solució (el fitxer $solution.cpp$) comprimida en un fitxer
$.tar$:

    tar cvf solution.tar solution.cpp

Només cal enviar la implementació del mètode $alumne\_nou$. Seguiu
estrictament la definició de la classe de l'enunciat.

::: multicols
2

## Exemple d'entrada sample-1

## Exemple de sortida sample-1
:::

::: multicols
2

## Exemple d'entrada sample-2

## Exemple de sortida sample-2
:::

::: multicols
2

## Exemple d'entrada sample-3

## Exemple de sortida sample-3
:::

::: multicols
2

## Exemple d'entrada sample-4

## Exemple de sortida sample-4
:::

::: multicols
2

## Exemple d'entrada sample-5

## Exemple de sortida sample-5
:::

## Informació del problema

Autoria: Ignasi Gómez Sebastià

Generació: 2026-01-25T21:17:18.514Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
