# Disorder Test

In a strictly increasing ordered sequence of integers $x_0,\ldots,x_r$
(such as 5, 8, 12, 20 for example) each element is strictly larger than
the previous one: $x_i > x_{i-1}$ for all $i > 0$, that is,
$x_{i-1} - x_i < 0$.

A $k$-ordered sequence is a sequence where $x_{i-1}-x_i < k$ for all
$i > 0$. Thus, a strictly increasing sequence is 0-ordered, and a
sequence that is increasing but maybe not strictly (like -3, -1 -1, 4,
4, 7 for example) is 1-ordered.

Larger values of $k$ represent bounded disorder: $k$ bounds how smaller
than its predecessor each element can be.

Write a function $disorder\_test(k, ls)$ that receives a nonnegative
integer $k$ and a list $ls$ of integers and checks whether $ls$ is
$k$-ordered, that is, returns `True` if $ls$ is $k$-ordered, and `False`
otherwise.

## Observation

Only the function will be evaluated. If your submission includes a main
program (e.g. with testmod), it must be either commented out or inside a
condition \"`if __name__ == ’__main__’`\"

## Problem information

Author: ProAl

Generation: 2026-01-25T17:01:57.619Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
