# Molecules with Potassium

As you may know, potassium has as chemical symbol K; only one other
element has a K in its symbol, namely, krypton Kr, a noble gas that
hardly ever participates in a molecule.

Your program must process a sequence of molecules, given by their
formulas, and none of which contains Kr. Your program should ignore all
molecules not containing potassium and, of the rest, it must report the
most frequent formula(s) among those coming in the sequence before the
first occurrence of NaCl (which is ignored from the counting as it does
not have K but, of course, is not ignored as an endmark).

## Input

Input is a sequence of molecules. There is no information about whether
they are organized in lines nor, if so, how. It is guaranteed that there
is at least one occurrence of the molecule NaCl and that, before it,
there is at least one occurrence of some molecule containing potassium.

## Output

Your program must write the most frequent molecule found in the sequence
before the first occurrence of NaCl, under the condition that only
molecules including potassium are to be considered. Molecules without
potassium are to be ignored, except for the endmarker NaCl. In case of a
tie, your program must output all the tied molecules, ordered from
smaller ones to larger ones according to Python3's str ordering. All
molecules printed out must be each on a line with no extra spaces or
lines.

## Problem information

Author: José Luis Balcázar

Generation: 2026-01-25T17:01:32.693Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
