# Intercala llistes

Feu el mètode `void intercala (const Llista<T>&);` de la classe
`Llista`, la implementació de la qual us donem al fitxer `llista.hpp`.

Quan cridem aquest mètode: `L1.intercala(L2);` on `L1, L2` són dues
llistes de tipus `Llista<T>` **doblement enllaçades**, la llista `L1` es
modifica de manera que té la llista `L2` intercalada (`L2` no es
modifica). Això vol dir que la llista `L1` comença amb el primer element
que ja tenia, seguit del primer de `L2`, el segon de `L1`, el tercer de
`L2`, \... fins que s'acaben tots els elements de totes dues llistes.

En general, si:

$$L1 = a_1, a_2, a_1, \dots, a_m$$ $$L2 = b_1, b_2, b_3 \dots, b_n$$

Després de fer la crida a `L1.intercala(L2)` tindrem que

$$L1 = a_1, b_1, a_2, b_2, a_3, b_3, \dots$$

Tingueu en compte que **no podeu assumir res** sobre les mides de totes
dues llistes, únicament que cap d'elles és buida.

## Entrada

El mètode rep una instància de tipus `Llista<T>` no buida. El paràmetre
implícit també és del mateix tipus i no és buit.

## Sortida

El mètode intercala la llista rebuda com a paràmetre al paràmetre
implícit.

## Observació

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar llista.cpp`

Observeu que per compilar us donem el `Makefile`, la capçalera del mòdul
funcional `pila.hpp`, que conté tota la implementació de tots els
mètodes, llevat del que heu d'implementar vosaltres, i el programa
principal `program.cpp`.

La solució es compilarà perquè el fitxer `llista.hpp` (que no heu de
modificar) té la següent línia:

`include "llista.cpp"`

## Informació del problema

Autoria: PRO1-Vilanova

Generació: 2026-01-25T21:17:02.741Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
