from pytokr import item, items
from collections import Counter

def my_intervalsum(lowerbd, upperbd, addends): # copy of the reference program
    def sublists(alist):
        from itertools import combinations
        for n in range(len(alist) + 1):
            "include both empty and total sublists"
            for sublist in combinations(alist, n):
                yield sublist

    size = len(addends)
    shortest = [0] * (size + 1)
    for sublist in sublists(addends): 
        if lowerbd <= sum(sublist) < upperbd:
            if len(sublist) < len(shortest):
                shortest = list(sublist) # they come as tuples
    if len(shortest) == size + 1:
        return list()
    else:
        return shortest

print("Jutge enters.")

for case in items():

    lowerbd = int(case)
    upperbd = int(item())
    size = int(item())
    addends = []
    for _ in range(size):
        addends.append(int(item()))
    print(lowerbd, upperbd, size, addends)
    sol0 = my_intervalsum(lowerbd, upperbd, addends)
    sol1 = sub_sum_interval(lowerbd, upperbd, addends)
    # my plan: Counter(sol1) <= Counter(addends) requires Python 3.10 :(
    if len(sol0) == len(sol1) == 0:
        print("OK")
    else:
        bag1 = Counter(sol1)
        bag = Counter(addends)
        for e in bag1:
            if bag1[e] > bag[e]:
                print("NO")
                break
        else:
            if lowerbd <= sum(sol1) < upperbd and len(sol0) == len(sol1):
                print("OK")
            else:
                print("KO")

print("Jutge exits.")