# Priority encoder

A priority encoder has 8 binary inputs and an integer output. The inputs
are numbered 0 to 7, whereas the value of the output is the integer that
corresponds to the largest index of the input having value 1. For
example, for input $x[7:0] = 01011100$, the output is $z=6$.
Additionally, there is an output (`active`) that indicates when there is
some 1 at the inputs.

Design a priority encoder using the decomposition shown in the figure.
The first circuit is a priority-resolution circuit that gives a 1 output
to the highest-priority input that has value 1 (all other outputs are
0). The second circuit is an encoder, that is, its output is an integer
representing the index of the input with value 1. This circuit also
detectes whether there is some active input.

When `active`=0, the value of `z` is a don't care.

::: center
![image](blocks.svg){width="7cm"}
:::

## Specification

    module priority_encoder(x, z, active);
        input [7:0] x;
        output [2:0] z;
        output active;

## Input

- `x` is the 8-bit input of the priority encoder.

## Output

- `z` is the 3-bit output of the encoder

- `active` is the signal that indicates whether some input is at 1.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:18:16.656Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
