# Joc solitari

Implementeu una funció **ITERATIVA** que donada $\emph{n}$ quantitat de
cartes i $\emph{s}$ cartes, classifiqui fins a 4 cues de cartes
ordenades de major a menor valor, inspirat en el joc del solitari.
Aquesta es la capçelera:

    //PRE: la cua v conte totes les cartes i la cua K conte nomes els reis
    //POST: Retorna la cua K ordenada amb cartes de major a menor i alternant els colors de les figures a partir de les cartes que es troben a la cua
    void ordena(queue v, queue &K);

Aquí tenim un exemple d'entrada i sortida de la funció:

    15 QD 7D QT 8T 4T 2T KT 6P 5C JC AC 10P 3C 9C KC =>

    KC QT JC 10P 9C 8T 7D 6P 5C 4T 3C 2T AC
    KT QD

- Les cartes que es donen es troben agrupades en piques $\emph{P}$ i
  Trebols $\emph{T}$ (aquestes són de color negre) i per altra part, els
  Diamants $\emph{D}$ i Cors $\emph{C}$ (aquestes són de color vermell).

- K es el valor més alt i A el menor. Pots interpretar K amb valor=13,
  Q=12, J=11 i A=1.

**Entrada**

L'entrada consisteix en $\emph{n}$ quantitat de cartes (natural
estrictament positiu) i $\emph{s}$ cartes (strings amb un màxim de 3
caràcters).

**Sortida**

En la sortida hi pot haver d'1 fins a 4 cues depenent de quants reis
s'hagin introduït en l'entrada. Les cues estaran ordenades de major a
menor valor, començant pel rei i el següent valor ha de ser estrictament
un valor menor, és a dir, la reina, i així consecutivament. A més a més,
ha d'anar intercalant colors. Si no es pot trobar la continuació del
nombre menor consegüent, no es pot acabar la cua.

- No poden haver-hi 2 cartes repetides.

- Els cors i les piques tenen prioritat de ser escollits com la carta
  menor següent abans que els diamants i els trèvols.

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Observació

- Si no rep cap rei en l'entrada, no es podrà realitzar la funció,
  donant per sortida: \"No s'ha pogut ordenar cap element.\", ja donat
  per al main.

- La vostra funció i subfuncions que creeu han de treballar només amb
  cues.

## Informació del problema

Autoria: Ilarion Nykolaychuk y Santiago Roa

Generació: 2026-01-25T16:56:01.672Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
