# Area of Circle Union

We want to calculate the area of the union of a set of circles. This is
a problem that has some non-trivial algorithm for the exact computation.
Instead, we would be satisfied by finding an approximation using a
Montecarlo method. The ideas is as follows:

- Calculate a bounding box around the circles.

- Generate random points within the bounding box.

- Count how many points are inside some circle.

0.4

0.1 $\Longrightarrow$

0.4

**Exam score:** 2.5 **Automatic part:** 100%

## Input

The input contains a set of cases. Each case specifies the number of
circles, $n\geq 0$, and the number of random points generated for the
Montecarlo approximation. After that, a list of $n$ circles is
specified, each one with the coordinates of the center, $(x,y)$, and the
radius. The coordinates and the radius are real numbers.

## Output

For every case print the estimated area as a real number in free format.

## Observation

There is no need to compute the exact area. The output will be
considered correct if it is a good approximation of the area.

## Problem information

Author: Professors de Info-FME

Generation: 2026-01-25T21:46:48.192Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
