# Portafolio de Inversiones

Paco es gerente de un banco, y ha observado que muchos de sus clientes
buscan alternativas para hacer crecer sus ahorros. Inspirado por la gran
variedad de fondos de inversión que ofrece el banco, él ha decido tomar
iniciativa y presentarles planes de ahorro personalizado. Paco sabe que
la mejor estrategia es diversificar la inversión, seleccionando
múltiples fondos de tal manera que se incrementen las ganancias
obtenidas para el cliente. Desafortunadamente, el ahorro del cliente es
limitado y las posibilidades de inversión muy variadas. Para complicar
un poco más las cosas, las ganancias son distintas para cada cliente.
Paco conoce a la perfección a cada cliente, por lo que sabe la inversión
necesaria y la ganancia específica a que puede aspirar por cada fondo.
Lo que no conoce es cuánto está dispuesto a invertir de sus ahorros el
cliente. Ayuda a Paco creando un programa que lo apoye en la creación de
los Portafolios de Inversiones Personalizados. El programa deberá
ofrecer la mejor estrategia de inversión seleccionando los fondos que
mejoren la ganancia del cliente a partir del ahorro que éste último
quiere utilizar, y de la información de inversión y ganancia asociada a
él que posee el gerente. Considere que la suma de las inversiones no
debe exceder los ahorros que el cliente desea invertir, y que la
inversión en un fondo es fija (no se puede reducir o incrementar).

Para ilustrar la situación, el cliente Enrique está dispuesto a invertir
80 pesos de sus ahorros, y las posibilidades de inversión son las
siguientes:

   **Fondo**   **Inversión**   **Ganancia**     
  ----------- --------------- -------------- -- --
     $F_1$          40              5           
     $F_2$          20              2           
     $F_3$          30              3           
     $F_4$          35              4           

Considerando lo anterior, Paco le indicó a Enrique que la mejor
estrategia de inversión sería que invirtiera 40 pesos en el fondo $F_1$
y $35$ en el fondo $F_4$, lo cual le proveería una ganancia de 9 pesos
inmejorable.

## Entrada

Una línea de entrada con dos valores enteros $n A$ indicando el número
$n$ de fondos de inversión disponibles para cliente y el ahorro $A$ a
considerar, seguida por $n$ líneas cada una conteniendo tres valores
enteros $i I_i G_i$ indicando el índice $i$ de referencia de la
inversión $F_i$, la inversión del fondo $I_i$ y la ganancia $G_i$ al
invertir.

## Salida

Una línea de salida conteniendo la ganancia máxima que se puede obtener.

## Observación

- Considere que $n \leq 1000$

- Considere que $A \leq 2000$

- No olvide imprimir un salto de línea al final.

## Información del problema

Autoría: Nelson Rangel Valdez

Generación: 2026-01-25T22:22:33.277Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
