#include "Palabra.hpp"

/*
 * Implementacion de la clase Palabra
 */

/* 
   Slo pueden estar en una palabra los caracteres a..z A..Z 0..9
   El resto se consideran separadores.

   Slo son relevantes las letras del vector situadas en las
   posiciones 0..longitud-1; las dems no se pueden visitar salvo
   para ocuparlas, aumentando por tanto la longitud.

   Las posiciones desde MAXLONG en adelante no se pueden ni
   consultar ni ocupar.
*/


/* Constructoras */
Palabra::Palabra ()
{
  letras = vector<char> (MAXLONG);
  longitud = 0;
}

Palabra::Palabra (int)
{ 
  letras = vector<char> (MAXLONG);
  leer_palabra ();

}

/* Consultoras de los campos */
int Palabra::longitud_maxima () const
{
  return MAXLONG;
}

int Palabra::long_pal () const
{
  return longitud;
}

char Palabra::consultar_letra (int i) const
{
  i--;
  if (i < 0)
    throw PRO2Excepcio ("Posicion negativa o cero");
  if (i >= longitud)
    throw PRO2Excepcio ("Posicion mayor que la longitud");
  return letras[i];
}

bool Palabra::marca () const
{
  return (longitud == 1 and letras[0] == MARCAFINAL);
}

bool Palabra::iguales (const Palabra & p) const
{
  bool b;
  if (longitud != p.longitud) b = false;   
  else
    {
      b = true;
      int i = 0;
      while (i < longitud and b)
	{
	  b = letras[i] == p.letras[i];
	  i++;
	}
    }
  return b;
}

/* Privada para filtrar los caracteres no vlidos */
bool esSeparador (char c, char m)
{ 
  // esta operacin no es de la clase: en su cdigo no reconocera MARCAFINAL
  // por eso aadimos un parametro caracter adicional para pasarle la marca, 
  // si no queremos hacer eso, y queremos usar la MARCAFINAL en el cdigo
  // hay que poner la operacion en el hpp como privada y aqui con ::

  if (c==m) return false;
  return (not(((47 < c) and (c < 58)) or	//numeros
	     ((64 < c) and (c < 91)) or	        //majuscules
	     ((96 < c) and (c < 123))));	//minuscules
}

/* Modificadoras de los campos */
void Palabra::anadir_letra (char c)
{
  if (longitud >= MAXLONG)
    throw PRO2Excepcio ("Palabra demasiado larga");
  if (esSeparador (c, MARCAFINAL))
    throw PRO2Excepcio ("Has intentado anadir un caracter no valido");

  letras[longitud] = c;
  longitud++;
}


/* Entrada / Salida */

void saltarSeparador (char m)
{ // id
  while (esSeparador (cin.peek (),m))	// and (cin.peek () != EOF))
    {                                   //Para secuencias sin marca final
      cin.ignore ();
    }
}


void Palabra::leer_palabra ()
{
  //Navega fins a la seguent paraula
  saltarSeparador (MARCAFINAL);

  //iniciem la paraula
  longitud = 0;

  //llegim la paraula
  while (not esSeparador (cin.peek (), MARCAFINAL)) // and (cin.peek () != EOF))
    //Para secuencias sin marca final
    {
      if (longitud >= MAXLONG)
	throw PRO2Excepcio ("Palabra demasiado larga");

      letras[longitud] = readchar ();
      longitud++;
    }
}


void Palabra::escribir_palabra () const
{
  for (int i = 0; i < longitud; i++)
    {
      cout << letras[i];
    }
}
