#include <iostream>
#include <string>
#include <stack>
#include <sstream>

using namespace std;

// Pre:  Siguin [a1,a2,...,an] i [b1,b2,...,bm] els valors inicials de q1 i q2, respectivament.
// Post: En el cas n>=m, la pila retornada és [a1,b1,a2,b2,...,am,bm,a{m+1},a{m+2},...,an].
//       En el cas n<m, la pila retornada és [b1,a1,b2,a2,...,bn,an,b{n+1},b{n+2},...,bm].
stack<int> intercal(stack<int> s1, stack<int> s2);

#ifndef IOSTACKFUNCTIONS
#define IOSTACKFUNCTIONS

stack<int> readStack(string line)
{
    istringstream mycin(line);
    stack<int> s;
    int x;
    while (mycin >> x)
        s.push(x);
    return s;
}


void writeStackRec(stack<int> &s)
{
    if (s.empty()) return;
    int x = s.top();
    s.pop();
    bool writespace = not s.empty();
    writeStackRec(s);
    if (writespace) cout << " ";
    cout << x;
}

void writeStack(stack<int> s)
{
    writeStackRec(s);
    cout << endl;
}

#endif

int main()  {
    string s;
    while (getline(cin, s)) {
        stack<int> s1 = readStack(s);
        getline(cin, s);
        stack<int> s2 = readStack(s);
        getline(cin, s);
        writeStack(intercal(s1, s2));
    }
}
