# Arbre binari. Elements del nivell $n$-èssim

Donada la classe $Abin$ que permet gestionar arbres binaris usant
memòria dinàmica, cal implementar el mètode

      void nivell(nat i) const;

que escriu una línia amb els elements del nivell $i$-èssim, d'esquerra a
dreta. Cada element ha de sortir precedit d'un espai.

Cal enviar a jutge.org la següent especificació de la classe $Abin$ i la
implementació del mètode dins del mateix fitxer.

    #include <iostream>
    #include <cstdlib>
    using namespace std;
    typedef unsigned int nat;

    template <typename T>
    class Abin {
      public:
        Abin(): _arrel(NULL) {};
        // Pre: cert
        // Post: el resultat és un arbre sense cap element
        Abin(Abin<T> &ae, const T &x, Abin<T> &ad);
        // Pre: cert
        // Post: el resultat és un arbre amb un element i dos subarbres

        // Les tres grans
        Abin(const Abin<T> &a);
        ~Abin();
        Abin<T>& operator=(const Abin<T>& a);

        // Escriu una línia amb els elements del nivell $i$-èssim, d'esquerra 
        // a dreta. Cada element ha de sortir precedit d’un espai.
        void nivell(nat i) const;

      private:
        struct node {
          node* f_esq;
          node* f_dret;
          T info;
        };
        node* _arrel;
        static node* copia_nodes(node* m);
        static void esborra_nodes(node* m);

        // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació del mètode nivell

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Abin$ i un programa principal que llegeix un arbre
binari i desprès crida vàries vegades el mètode $nivell$

## Entrada

L'entrada consisteix en la descripció d'un arbre binari d'enters (el seu
recorregut en preordre, en el qual inclou les fulles marcades amb un
-1). Per exemple, l'arbre (mira el PDF de l'enunciat)

<figure data-latex-placement="h">
<img src="exemple_arbre_binari.png" />
</figure>

es descriuria amb

    3 0 7 -1 4 -1 -1 2 -1 -1 5 4 -1 -1 7 6 -1 1 -1 -1 -1

## Sortida

Una línia per cada element $i$ de la seqüència d'enters d'entrada, amb
els elements de l'arbre situats en el nivell $i$, d'esquerra a dreta.
Cada element surt precedit d'un espai.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$nivell$. Pots ampliar la classe amb mètodes privats. Segueix
estrictament la definició de la classe de l'enunciat.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T16:33:56.700Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
