# Encuar amb preferència usant memòria dinàmica

Escriviu el codi del mètode `encuar_preferencia` de la classe `Cua` que,
donada una cua d'enters i un enter, afegeix l'enter a la cua, colant-se
al davant d'un altre enter amb el mateix valor, si n'hi ha algun;
altrament, s'afegeix al darrere de tot:

``` c++
void encuar_preferencia(const int &elem);
/* Pre: El p.i. conte una cua C */
/* Post: El p.i. passa a ser el resultat d'afegir elem a C
al davant del primer element igual que ell, si n'hi ha
algun; altrament, s'afegeix al darrere de tot. */
```

## Entrada

Com a entrada hi haurà una cua: el nombre d'enters i els enters que la
formen. A continuació hi hauran un o més enters addicionals.

Per llegir les cues, s'ha utilitzat l'operador `>>` que es troba definit
a la classe `Cua`.

## Sortida

Com a sortida es mostrarà la cua original. A continuació s'aniran
encuant amb preferència els enters addicionals de l'entrada, sempre a la
cua modificada en el pas anterior. Si l'enter a encuar és positiu,
desprès d'encuar-lo amb preferència es mostrarà la cua actual. Si no és
positiu només s'encua amb preferència.

Per escriure les cues, s'ha utilitzat l'operador `<<` que es troba
definit a la classe `Cua`.

## Observació

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar cua_encuar_preferencia.cpp`

Observeu que per compilar us donem el `Makefile`, la classe `Cua` amb
tots els seus mètodes implementats excepte `encuar_preferencia` i el
programa principal `program.cpp`.

## Informació del problema

Autoria: Neus Català - Jordi Esteve

Generació: 2026-01-25T21:13:26.488Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
