# Ranking a Poker hand (2)

The following are some of the possible hands in Poker, in increasing
order of value:

- One pair: Two cards with the same rank.

- Two pair: Two pairs of cards with the same rank.

- Three of a kind: Three cards with the same rank.

- Straight: Five cards with ranks in sequence (aces can be high or low,
  so Ace-2-3-4-5 is a straight and so is 10-Jack-Queen-King-Ace, but
  Queen-King-Ace-2-3 is not.)

- Flush: Five cards with the same suit.

- Full house: Three cards with one rank, two cards with another.

- Four of a kind: Four cards with the same rank.

- Straight flush: Five cards with ranks in sequence (as defined above)
  and with the same suit.

Using the \@Card@, \@Deck@, \@Hand@, \@PokerDeck@, and \@PokerHand@
class definitions, write a \@PokerHand@ method named \@classify@ that
figures out the highest-value classification for a Poker hand and sets
the label attribute accordingly.

Your code should work correctly for hands that contain 5 cards.

## Input

The input consist of two non-negative integers, the number of hands and
the number of cards per hand, followed by a shuffled deck of cards.

## Output

Print the cards in each hand followed by a blank line, and a line with
the classification of the hand, followed by a blank line.

## Precondition

The number of cards in the shuffled deck is not less than the number of
hands times the number of cards per hand.

## Problem information

Author: Gabriel Valiente

Generation: 2026-01-25T16:25:28.996Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
