# Práctica de PRO2 - Primavera 2024 - entrega provisional

Este problema es el único canal disponible para realizar **entregas
provisionales** de la práctica, es decir, las entregas realizadas en
este problema no afectarán la nota de la práctica. Tened en cuenta que

- Más adelante habrá otro problema del jutge para hacer la entrega
  definitiva, que requerirá incluir documentación extra.

- El plazo para la entrega definitiva acaba el martes 28 de mayo, a las
  22h.

- No superar ningún juego de pruebas en la entrega definitiva conllevará
  un cero en la nota de la práctica

- El problema del Jutge de la entrega definitiva puede contener juegos
  de prueba o condiciones diferentes de los que aparecen en este
  problema

- En esta entrega no pedimos carpetas generadas mediante doxygen, pero
  los ficheros de las clases pueden llevar todos los comentarios doxygen
  que queráis; de hecho recomendamos que incluyáis las especificaciones
  de todas las operaciones y que sean lo más definitivas posible

- Este problema de la entrega provisional seguirá disponible hasta horas
  antes del fin del plazo de entrega. De hecho, recomendamos usarlo para
  probar el código mientras no tengáis preparado el material adicional
  que pedimos y esté disponible la entrega final definitiva.

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: un poco de todo, especialmente *hacer viaje*, salvo
  eficiencia

- privat2: un poco de todo, especialmente *comerciar* y *reorganizar*,
  salvo eficiencia

- privat3: eficiencia

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros .hh y .cc de las clases y el programa principal. No
  incluyáis ficheros .o, .exe y similares

- El fichero **Makefile**, que usaremos para generar y probar el
  ejecutable; un Makefile incorrecto puede dar lugar a malos resultados
  en el Jutge o a penalización en la nota manual

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El Makefile ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

- No usar la opción `-fno-extended-identifiers` **comporta un 0 en la
  práctica**.

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciréis el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:13:13.316Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
