# Suma Bicreixent

Una seqüència és **bicreixent** si és la concatenació de dues seqüències
creixents, tals que l'últim element de la primera seqüència és més gran
que el primer element de la segona seqüència. És a dir, la seqüència

$$S = \{ s_1, s_2, s_3, \dots, s_N \}$$

és bicreixent si i només si:

1.  Hi ha un subíndex $m$ tal que $2 \leq m \leq N-1$ i $s_{m-1} > s_m$.

2.  Per a tots els subíndexos $i$ tal que $2 \leq i \leq N$ i
    $i \neq m$, es compleix que $s_{i-1} \leq s_i$.

Sigui `V` un vector que conté una seqüència **bicreixent**. Podem veure
aquest vector com la concatenació de dos vectors creixents `V1` i `V2`
tals que `V1[len(V1)-1] > V2[0]`.

Feu la funció `suma_bicreixent(V)` tal que, donat un vector `V` que
conté una seqüència bicreixent (és a dir, no cal que ho comproveu,
sempre serà bicreixent), torni `True` si i només si la suma de tots dos
vectors *creixents* de què es composa el vector `V` és igual. Per
exemple, si el vector és:

::: center
  ----- --- --- --- --- --- --- ---
   V =   1   2   3   4   1   4   5
  ----- --- --- --- --- --- --- ---
:::

la funció torna `True` ja que la suma de $[1, 2, 3, 4]$ és igual a la
suma de $[1, 4, 5]$, mentre que si el vector és

::: center
  ----- --- --- ---- ---- --- --- ---
   V =   1   3   15   26   1   3   6
  ----- --- --- ---- ---- --- --- ---
:::

tornarà `FALSE`, ja que la suma de $[1 , 3 , 15 , 26]$ és diferent a la
suma de $[1, 3, 6]$

## Entrada

Un vector `V` d'enters amb una seqüència bicreixent.

## Sortida

`True` si i només si la suma de tots dos vectors *creixents* de què es
composa el vector `V` és igual.

## Informació del problema

Autoria: Jaume Baixeries

Generació: 2026-01-25T18:56:14.114Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
