# Seguiment de comptes en vermell (COPY)

Heu d'implementar un programa que manega els diners dels comptes de
clients d'un banc i monitoritza quants i quins d'aquests clients estan
en nombres vermells (diners negatius).

Al principi de l'execució se suposa que tothom té saldo 0.

L'entrada consistirà en una llista de comandes. Entre elles, hi ha
comandes de moviments bancaris, que afegeixen o treuen diners a un
client. Per exemple:

    TRANSACTION maria.lapuente 10
    TRANSACTION maria.lapuente -8
    TRANSACTION john.smith -3
    TRANSACTION nuria.margalef 5
    TRANSACTION laura.venture -15
    TRANSACTION maria.lapuente -5
    TRANSACTION laura.venture 20
    TRANSACTION maria.lapuente 2
    TRANSACTION nuria.margalef 10

També hi ha comandes que demanen quantes persones en nombres vermells hi
ha:

    NUMBERINRED

Incloent les comandes prèvies de moviments bancaris, la sortida seria
aquesta:

    2

També hi ha comandes que demanen la llista de persones en nombres
vermells, en ordre lexicogràfic:

    PEOPLEINRED

Incloent les comandes prèvies de moviments bancaris, la sortida seria
aquesta:

    john.smith maria.lapuente

**Observació:** Podeu seguir l'enfoc que considereu oportú, i podeu
utilitzar qualsevol de les classes presentades al curs (**string,
vector, stack, queue, list, map, set**) de la manera que considereu
oportuna. Però tingueu en compte que la vostra elecció pot afectar a
l'eficiència de la vostra solució, i per tant al fet de poder superar
tots els jocs de proves o només els públics (cosa que us deixarà amb la
meitat de la nota).

## Entrada

Cada linia de l'entrada consisteix en una instrucció del següent tipus,
a on `client` es pot llegir com string no buit qualsevol, i té menys de
20 caràcters, i `integer` és un enter qualsevol:

- `TRANSACTION client integer`

- `NUMBERINRED`

- `PEOPLEINRED`

## Sortida

Per a cada instrucció `NUMBERINRED`, s'escriurà una línia per la sortida
amb el nombre de clients actuals en vermell.

Per a cada instrucció `PEOPLEINRED`, s'escriurà una línia per la sortida
amb tots els clients actuals en vermell, ordenada lexicogràficament, i
separada per espais en blanc.

## Observació

Avaluació sobre 10 punts:

- Solució lenta: 5 punts.

- solució ràpida: 10 punts.

Entenem com a solució ràpida una que és correcta, de cost $n\log(n)$ o
inferior, i capaç de superar els jocs de proves públics i privats.
Entenem com a solució lenta una que no és ràpida, però és correcta i
capaç de superar els jocs de proves públics.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T16:16:16.717Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
