# Extraer teléfonos

Escribe una función llamada `extraertelefonos`. Dicha función recibirá
como único parámetro una cadena de caracteres. La función deberá
devolver un diccionario cuyas claves serán cadenas de caracteres y cuyos
valores serán números enteros.

La cadena de caracteres recibida como parámetro será una oración en
castellano, en la cual los signos de puntuación estarán separados de las
palabras por espacios en blanco. Por ejemplo:
`Vivo en el número 29 de la calle Falsa . Mi número de teléfono es 623456789 , y el de mi empresa es 699999977 . Por si no ha quedado claro , mi teléfono es 623456789 `.

La función deberá identificar y contar en la oración aquellas palabras
que son números de teléfono. Para identificar palabras, simplemente
habrá que trocear la cadena utilizando como separador el espacio en
blanco. Los números de teléfono serán palabras compuestas por
exactamente 9 dígitos.

El diccionario que devolverá la función contendrá, como claves, los
números de teléfono que aparecen en la oración y, como valores, el
número de veces que aparece cada teléfono. Si la oración de entrada no
contiene teléfonos, habrá que devolver un diccionario vacío.

Por ejemplo, para la cadena de entrada mencionada anteriormente, la
función deberá devolver el diccionario {@\"623456789\": 2 ,
\"699999977\": 1@}. Ten en cuenta que el orden de las claves en un
diccionario es irrelevante, así que no te preocupes si, al imprimir el
diccionario producido por tu función, obtienes {@\"699999977\": 1 ,
\"623456789\": 2@}.

Si se recibe como entrada una lista vacía, la función deberá devolver un
diccionario vacío.

Para que tu función pueda ser evaluada correctamente por el juez en
línea, tu código deberá tener la siguiente forma:

``` python
import sys

def extraertelefonos(c):
...

c=sys.stdin.readline().strip()
resultado=extraertelefonos(c)
print( "+".join( sorted([ k+":"+str(resultado[k])  for k in resultado ]) )  )
```

## Entrada

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) Una línea que contendrá la oración de entrada.

## Salida

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) El contenido del diccionario en una sola línea.
Cada elemento del diccionario estará separado por el carácter `+`. Clave
y valor estarán separados por dos puntos. Los elementos estarán
ordenados alfabéticamente.

## Información del problema

Autoría: Víctor M. Sánchez Cartagena

Generación: 2026-01-25T18:55:17.481Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
