# Fitxers amb la mateixa extensió

En aquest exercici, considerarem arbres binaris d'strings que
representen arbres de directoris i fitxers. Observeu el següent exemple:

                                      fotos
                                        |
                          -------------- --------------
                         |                             |
                      antigues                       noves
                         |                             |
              ----------- -----------            ------ ------
             |                       |          |             |
          familia                  amics     familia        amics
             |                       |          |             |
        ----- -----              ----       ---- ----          ----
       |           |            |          |         |             |
    pau.jpg    nuria.png    joel.jpeg     casa    vacances     marta.png
                                                     |
                                               ------ ------
                                              |             |
                                           roma.bmp    newyork.png

En un arbre de directoris i fitxers hi ha dos tipus de nodes: directoris
i fitxers. L'string d'un directori és no buit i està format per lletres
minúscules. L'string d'un fitxer està format per una primera seqüència
no buida de lletres minúscules, seguida del caràcter '.', seguit d'una
segona seqüència no buida de lletres minúscules. Aquesta segona
seqüència s'anomena la extensió del fitxer. Els fitxers han de ser
necessàriament fulles de l'arbre. Els directoris poden ser nodes interns
i també fulles.

Heu d'implementar una funció que rep un arbre de directoris i fitxers, i
retorna un booleà indicant si tots els fitxers tenen exactament la
mateixa extensió. En l'exemple anterior, la funció ha de retornar
`false`, doncs tenim més d'una extensió diferent: `jpg`, `png`, `jpeg` i
`bmp`. En canvi, en l'exemple següent, la funció ha de retornar `true`,
perquè totes les extensions son la mateixa: `cc`.

                                             programes
                                                 |
                              ------------------- -------------------
                             |                                       |
                         ordenacio                               recorregut
                             |                                       |
                ------------- -------------                    ------ ------
               |                           |                  |             |
             lents                       rapids          profunditat    breadth.cc
               |                           |                  |
         ------ ------                 ----            ------- -------
        |             |               |               |               |
    bubble.cc    insertion.cc    mergesort.cc    preorder.cc     postorder.cc

Aquesta és la capcelera:

    // Pre:  Els nodes de t o bé son strings no buits de lletres minuscules, o bé
    //       son de la forma "s.e", on s i e son strings no buits de lletres minúscules.
    //       En l'últim cas, el node ha de ser una fulla, i e s'anomena la extensió de la fulla.
    // Post: Retorna cert si i només si totes les extensions de les fulles de t son iguals.
    bool sameExtension(BinTree<string> t);

Fixeu-vos que l'enunciat d'aquest exercici ja ofereix uns fitxers que
haureu d'utilitzar per a compilar:
`main.cc, BinaryTree.hh, sameExtension.hh`. Us falta crear el fitxer
`sameExtension.cc` amb els corresponents `includes` i implementar-hi la
funció anterior. Només cal que pugeu `sameExtension.cc` al jutge.

**Observació1:** Donat un string `s` i un índex `i`, podeu utilitzar
`s.substr(i)` per a obtenir el substring que és el sufix de `s` a partir
de posició `i`.

**Observació2:** Convindrà que penseu bé en quines funcions auxiliars us
convé implementar per tal que us surti una solució no massa complicada.

## Entrada

La primera linia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre
binari d'strings que representa un arbre de directoris i fitxers.
Fixeu-vos en que el programa que us oferim ja s'encarrega de llegir
aquestes entrades. Només cal que implementeu la funció abans esmentada.

## Sortida

Per a cada cas, la sortida conté `true` si totes les extensions del
corresponent arbre d'entrada son iguals, i `false` en cas contrari.
Fixeu-vos en que el programa que us oferim ja s'encarrega d'escriure el
resultat. Només cal que implementeu la funció abans esmentada.

## Observació

Podeu implementar les funcions auxiliars que considereu necessàries,
però la vostra funció i subfuncions que creeu han de treballar només amb
arbres. Per a resoldre aquest exercici, no us permetem utilitzar cap
mecanisme d'enmagatzemament massiu de dades a part del propi arbre
binari que es rep com a paràmetre, i els strings que siguin necessaris.
Us recomanem, doncs, que resolgueu aquest exercici recursivament.

## Informació del problema

Autoria: PRO2

Generació: 2026-01-25T16:10:46.491Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
