# Práctica de PRO2 - Otoño 2023 - entrega definitiva

Este problema es el único canal disponible para realizar **la entrega
definitiva** de la práctica. Tened en cuenta que

- El plazo de entrega definitiva acaba el domingo 17 de diciembre, a las
  22h.

- Esta es la entrega que dará lugar al total de la nota de la práctica;
  la nota de la entrega tendrá una parte procedente de corrección
  automática, otra procedente de corrección manual y otra procedente de
  las justificaciones de operaciones seleccionadas (consultad los
  detalles en el pdf sobre evaluación en el apartado "Pràctica" de la
  web de PRO2)

- No superar ningún juego de pruebas conllevará un cero en la nota de la
  práctica

- En esta entrega pedimos más cosas, que detallamos a continuación **en
  negrita**, además del código de la práctica y el Makefile, de las que
  se pedían en la entrega provisional

- Pueden realizarse tantas entregas como se quiera, pero solo se tendrá
  en cuenta la más reciente que no sea SE (\"Setter Error").

- El problema de la entrega final provisional seguirá disponible hasta
  horas antes del fin del plazo de entrega. De hecho, recomendamos
  usarlo para probar el código mientras no tengáis preparado el material
  adicional que pedimos

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: un poco de todo, especialmente *subir bicis*, salvo
  eficiencia

- privat2: un poco de todo, especialmente *asignar estacion*, salvo
  eficiencia

- privat3: eficiencia

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros .hh y .cc de las clases y el programa principal **con los
  comentarios Doxygen correspondientes**. No incluyáis ficheros .o, .exe
  y similares

- El fichero **Makefile**, que usaremos para generar y probar el
  ejecutable; un Makefile incorrecto puede dar lugar a malos resultados
  en el Jutge o a penalización en la nota manual

- **Un fichero `html.zip`, obtenido comprimiendo la carpeta html del
  Doxygen generado a partir de los .hh y .cc anteriores. Dicha
  documentación no solo ha de incluir la parte pública de las clases
  sino también la parte privada (atributos y métodos privados) y la
  implementación de todas las operaciones**

- **Documento pdf que cumpla con el aviso del racó del jueves 7 de
  diciembre**

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El Makefile ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` en el Makefile o usarla de forma
  incorrecta podrá ser penalizado

- No usar la opción `-fno-extended-identifiers` en el Makefile
  **comporta un 0 en la práctica**.

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciréis el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:12:01.166Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
