# Deanonymizing Grades

We are to receive a list of grades for several courses and students.
However, for privacy, they are provided anonymized: students will appear
there identified by an anonymous numeric code. Separately, we have as
well the code corresponding to each student's name (assumed a single
word for simplicity). We want to list the plain names and codes together
with the average grade of each student. The list must have a line per
student, start with the student's name, and then indicate the code and
the average grade; and must be ordered according to the numeric code.

## Input

First comes alone in a line the number of students $n$. Then come $n$
pairs, each in a line, consisting of a student name and a numeric code,
separated by a space. It is guaranteed that all the codes are different,
and so are as well the names. Then comes the total number of grades $m$
followed by $m$ lines with grades: each line has, first, the numeric
code of some student, then the mark of the student (a float) for one of
the evaluable acivities of some course, also separated by a space.

## Output

Output must not include students with no grades. As for the rest, output
consists of as many lines as students. Each line starts with the name of
the student, then the numeric code corresponding to the student, and the
average grade of the student. Print all floats rounded to two decimal
places. The lines must come ordered according to the numeric code.
Inside each line, everything must come separated by single spaces. There
should not be trailing spaces.

## Problem information

Author: José Luis Balcázar

Generation: 2026-01-25T16:00:11.847Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
