# Examen de la práctica de PRO2 - Otoño 2022

El objetivo en este examen será modificar dos aspectos de tu solución de
la práctica. Concretamente deberás

1.  cambiar el algoritmo de codificación/decodificación por sustitución

2.  reorganizar las funcionalidades de codificación/decodificación del
    main

Los detalles están descritos con precisión en el documento
` enunciado_examen.pdf` que forma parte del archivo `public.tar` que
puedes descargar en esta página (icono del gatito). Verás que tendrás
que modificar elementos ya existentes en tu práctica, tanto del main
como de algunas clases.

IMPORTANTE: Este problema de Jutge es el único canal disponible para
realizar la entrega del examen de la práctica. Ten en cuenta que

- Dispondrás de 2h 15 min (aprox) para la resolución del examen.

- La nota del examen procederá exclusivamente de la corrección
  automática de tu último envío. No penaliza el número de intentos.

- No superar ningún juego de pruebas conlleva un cero en la nota de este
  examen, al igual que si se aprecian indicios suficientes de copia.

## Observación

Recomendamos que hagas una copia "limpia" de tu práctica en un
subdirectorio aparte y en esa copia lleves a cabo todos los cambios.

Verifica que todos los módulos compilan sin errores, que el proceso de
montaje da un archivo ejecutable correcto y que el `program.exe` pasa el
juego de pruebas público suministrado.

Comprueba que tu `Makefile` genera el fichero `program.exe` y crea el
fichero `.tar` para hacer el envío al Jutge. Asegúrate que entregas el
fichero `.tar` con la solución del examen, no la solución original. No
es necesario incluir la carpeta con la documentación en Doxygen ni, en
su caso, la de la competencia tranversal.

El Jutge prueba tus entregas mediante 4 juegos de pruebas que, salvo por
un comando que cambia ligeramente, tienen la misma sintaxis que los de
la práctica.

- sample: el juego de pruebas público

- privat1: situaciones que no aparecen en el público

- privat2: mucho de todo: alfabetos, mensajes y operaciones de
  codificar/decodificar

- privat3: mensajes grandes

En un fichero llamado `practica.tar` debes entregar

- Los ficheros `.hh` y `.cc` de las clases y el programa principal. No
  incluyas ficheros `.o` y similares.

- El fichero `Makefile`, que usaremos para generar y probar el
  ejecutable

Ten en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  ` program.cc`

- El `Makefile` ha de generar un ejecutable llamado `program.exe`

- Es importante que uses las opciones de compilación del Jutge de PRO2
  (véase Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 en
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

Produce el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengas los ficheros que vas a
entregar. Incluye esta instrucción en tu Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciras el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge.

## Información del problema

Autoría: PRO2

Generación: 2026-01-25T21:11:28.038Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
