# Isomorfisme d'arbres binaris

Feu una funció tal que, donats dos arbres binaris, torni `true` si i
només si tots dos arbres són isomorfs.

**Isomorfisme** vol dir *que tenen la mateixa (iso, en grec) forma
(morphe, en grec)*. Això vol dir que si quan **sobreposem** tots dos
arbres tenen la mateixa forma, vol dir que són isomorfs, encara que el
contingut als nodes no coincideixi. Per exemple, aquest dos arbres són
isomorfs

                            1          4
                           / \        / \
                          3   8      5   6
                         / \        / \
                        2   6      1   9

En canvi, aquests dos no ho són:

                            1          1
                           / \        / \
                          3   8      3   8
                         / \        / \   \
                        2   6      2   6   4

La funció que heu de programar és:

`bool isomorfs (arbreBin<int>&, arbreBin<int>&);`

i l'heu de posar al fitxer `isomorfs.cpp`.

Tingueu en compte que la gestió d el'entrada i la sortida la fa el
programa principal que ja us passem. Només cal que programeu la funció i
prou.

## Entrada

Dos arbres amb el següent format: la mida de l'arbre i els nodes en
postordre d'un arbre binari; per cada node s'indica el seu valor i el
nombre de fills.

## Sortida

`SI` (sense accent) si tots dos arbres són isomorfs, `NO` altrament.

## Observació

Heu d'enviar la solució comprimida en un fitxer .tar:

`tar cvf program.tar isomorfs.cpp`

Observeu que per compilar us donem el `Makefile`, la classe
`arbreBin.hpp`, la capçalera del mòdul funcional `isomorfs.hpp` i el
programa principal `program.cpp`.

Jutge.org també us donarà un semàfor verd si envieu una solució
iterativa, però no serà correcte ja que l'enunciat del problema demana
que la solució enviada sigui **recursiva**.

## Informació del problema

Autoria: PRO1-Vilanova

Generació: 2026-01-25T21:10:58.758Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
