# Tic-tac-toe

A Tic-tac-toe board can be represented by a binary matrix where the ones
and zeros represent the $\times$ and $\bigcirc$ marks, respectively. The
following board represents a possible final configuration after playing
the game.

:::: NoShortVerb
::: center
   1   0   1
  --- --- ---
   1   1   0
   0   0   1
:::
::::

We can represent the board with a 9-bit vector, with the indices of the
vector representing the board locations as follows:

:::: NoShortVerb
::: center
   8   7   6
  --- --- ---
   5   4   3
   2   1   0
:::
::::

Thus, the previous board would be represented with the bit-vector
`101110001`. Note that a board may contain more than one row of ones and
more than one row of zeros.

Design a circuit that receives a board description and generates two
outputs. One output will be activated when there is at least one row of
ones (vertical, horizontal or diagonal). The other output will be
activated when there is at least one row of zeros.

## Specification

``` verilog
module tictactoe(board, row1, row0);
    input [8:0] board;
    output row0, row1;
```

## Hint

Try to minimize the effort by reusing the design of some module in the
same circuit.

## Input

- `board` is a 9-bit vector describing a Tic-tac-toe board.

## Output

- `row1` is the output indicating whether there is a row of ones.

- `row0` is the output indicating whether there is a row of zeros.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:19:47.304Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
