# Word Bigram Counts

A *word bigram* is a combination of two words appearing consecutively in
a text. For instance the text *\"tea for you and tea for me\"* contains
5 different bigrams: *tea+for* (occurring twice), *for+you*, *you+and*,
*and+tea*, *for+me*.

Write a program that reads a text given as input, counts the bigrams it
contains, and produces a list with the total count of bigrams starting
with each word, and the relative frequency of the second word. The list
must contain only those words that happen more than once *as first word*
in a bigram.

Note that the last word in the text is not the *first word* in any
bigram, so it is not counted in the number of bigrams starting with that
word.

For instance, in the sentence *\"tea for you and tea for me and for him
also tea\"*, we obtain the following counts:

- Word *and* happens 2 times as a bigram first word. Once (50%) followed
  by *tea* and once (50%) followed by *for*.

- Word *for* happens 3 times as a bigram first word. Once (33%) followed
  by *you*, once (33%) followed by *me*, and once (33%) followed by
  *him*.

- Word *tea* happens 2 times as a bigram first word. Both times (i.e.
  100%) is followed by *for*. Word *tea* also happens a third time (last
  word in the text) but since that occurrence is not first word of any
  bigram, it is not counted as such.

- Words *you*, *me*, *also*, and *him* happen only once as bigram first
  word, so they are not included in the final list.

So, the expected output would be:

    and 2 : for 0.5 tea 0.5
    for 3 : him 0.333 me 0.333 you 0.333
    tea 2 : for 1.0

## Input

The input is a text. It may consist of several lines.

## Output

The output is a list where for each word appearing more than once, the
number of occurrences is provided, followed by the words occurring right
after, along with their relative frequencies.

Relative frequencies are rounded to 3 decimal places. Use `round(x,3)`
to round a float value `x` to 3 decimals.\
The word list is ordered alphabetically.\
The list of second words seen after each word is also ordered
alphabetically.

Follow the output format shown in the examples.

## Problem information

Author: ProAl1 professors

Generation: 2026-01-25T15:48:56.818Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
