# Escalas y acordes

En música con afinación temperada, la octava se subdivide en 12
semitonos de igual intervalo. Por razones históricas, sólo 7 notas
tienen nombre, Do Re Mi Fa Sol La Si (las notas naturales), así que para
nombrar los 12 huecos se idearon las alteraciones, $\sharp$ (sostenido o
semitono arriba) y $\flat$ (bemol o semitono abajo). De esta manera
Mi$\sharp$ es un sonido que suena un semitono por encima del Mi.

Hay tonos que, en afinación temperada, pueden recibir varios nombres.
Así, por ejemplo, Mi$\sharp$ da nombre al mismo tono que Fa. A estos
casos se les llama notas enarmónicas. En un enarmónico no se puede
mezclar alteraciones distintas: es posible Mi$\sharp\sharp$ pero no
Mi$\sharp\flat$.

# Escala cromática

La escala cromática es aquella que se genera dando nombre a los 12
semitonos a partir de las 7 notas naturales y hasta un máximo de 2
alteraciones para generar la máxima cantidad de enarmónicos. Las notas
naturales, comenzando por el Do, se sitúan en los tonos 0, 2, 4, 5, 7,
9, 11. Desde ahí, y aplicando las dos alteraciones, se generan todos los
enarmónicos posibles para los 12 tonos.

Diseña una función \@escala_cromatica(notas)@ que, dada una lista
\@notas@ que contiene los nombres (str) de las notas naturales en sus
posiciones respectivas, y el string vacío en el resto, devuelva la una
lista de listas que contenga la escala cromática usando el nombre de las
notas naturales definido en la lista \@notas@.

# Nota natural

Es frecuente necesitar conocer la nota natural asociada a un nombre de
nota, o lo que es lo mismo, el nombre de la nota sin las alteraciones.

Diseña una función \@nota_natural(nota)@ que, dado un str \@nota@,
devuelva su nota natural.

# Número de una nota

Dado el nombre de una nota, puede ser interesante conocer a cuál de de
los 12 tonos de la escala cromática se refiere.

Diseña una función \@nota_a_numero(nota, escala)@ que, dado un str
\@nota@ con el nombre de una nota, y una lista de listas \@escala@ que
contiene una escala cromática en la que \@nota@ existe, devuelva el
número del tono de la escala cromática al que \@nota@ hace referencia.

# Intervalo entre notas

Intervalo es la distancia en relación a una escala entre dos notas
musicales (incluyendo los extremos) medido en semitonos.

Diseña una función \@intervalo(nota1, nota2, escala)@ que, dados dos str
\@nota1@ y \@nota2@ que representan el nombre de dos notas, y una lista
de listas \@escala@ que contiene una escala cromática donde ambas notas
\@nota1@ y \@nota2@ existen, devuelva un int con el intervalo en
semitonos que hay desde \@nota1@ hasta \@nota2@.

# Enarmónicas

Diseña una función \@enarmonicas(nota, cromatica)@ que, dado un str
\@nota@ con el nombre de una nota, y una lista de listas \@cromatica@
que contiene una escala cromática en la que \@nota@ existe, devuelva una
nueva lista con los nombres de todas sus notas enarmónicas.

# Escalas diatónicas

Una escala diatónica es una serie de 7 notas tomadas ordenadamente del
total de 12 de la escala cromática a partir de una tónica y siguiendo un
patrón de saltos de semitonos diatónicos (después de un Do nunca habrá
un Do$\sharp$ sino Re$\flat$) de manera que siempre estén representadas
en orden las 7 notas naturales una única vez cada una, ya sea en su
estado natural o alteradas.

Diseña una función \@escala_diatonica(tonica, modo, cromatica)@ que,
dado un str \@tonica@ con el nombre de una nota, una lista \@modo@ con
un patrón de saltos de semitonos, y una lista de listas \@cromatica@ que
contiene una escala cromática en la que \@tonica@ existe, devuelva una
lista de 7 str que contenga la escala diatónica cuya tónica sea
\@tonica@ siguiendo el patrón de saltos diatónicos indicado por \@modo@.

# Acordes de tríada

Un acorde tríada consiste en un conjunto de tres notas diferentes que
constituyen una unidad armónica y reciben el nombre de tónica, tercera y
quinta, porque el acorde lo forman las notas 0, 2 y 4 de la escala
diatónica correspondiente.

Diseña una función \@acorde_triada(tonica, modo, cromatica)@ que, dado
un str \@tonica@ con el nombre de una nota, una lista \@modo@ con un
patrón de saltos de semitonos, y una lista de listas \@cromatica@ que
contiene una escala cromática en la que \@tonica@ existe, devuelva una
lista con las tres notas del acorde tríada extraidas de la escala
diatónica para \@tonica@ y \@modo@.

## Ejemplo de sessión

## Información del problema

Autoría: InfBesos

Generación: 2026-01-25T15:45:40.280Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
