# Scales and chords

In music with tempered tuning, the octave is subdivided into 12
semitones of the same interval. For historical reasons, only 7 notes
have a name, Do Re Mi Fa Sol La Si (the natural notes), so to name the
12 tones accidentals were devised, $\sharp$ (sharp or semitone up) and
$\flat$ (flat or semitone down). In this way Mi$\sharp$ is a tone that
sounds one semitone above Mi.

There are tones that, in tempered tuning, can receive various names. So,
for example, Mi$\sharp$ names the same tone as Fa. These cases are
called enharmonic notes. An enharmonic cannot be affected by different
alterations: Mi$\sharp\sharp$ is possible but not Mi$\sharp\flat$.

# Chromatic scale

The chromatic scale is the one that is generated by naming the 12
semitones from the 7 natural notes and up to a maximum of 2 alterations
to generate the maximum amount of enharmonics. The natural notes,
starting with Do, are placed in tones 0, 2, 4, 5, 7, 9, 11. From there,
and applying the two alterations, all possible enharmonics are generated
for the 12 tones.

Design a function \@escala_cromatica(notas)@ that, given a list \@notas@
containing the names (str) of the natural notes in their respective
positions, and the empty string in the rest, returns a list of lists
containing the chromatic scale using the names of the natural notes
defined in \@notas@.

# Natural note

It is a common need to know the natural note associated with a note
name, or what is the same, the note name without accidentals.

Design a function \@nota_natural(nota)@ that, given a str \@nota@,
returns its natural note.

# Note number

Given the name of a note, it is good to know which of the 12 tones of
the chromatic scale it names.

Design a function \@nota_a_numero(nota, escala)@ that, given a str
\@nota@ with the name of a note, and a list of lists \@escala@
containing a chromatic scale in which \@nota@ exists, returns the tone
number of the chromatic scale that \@nota@ refers to.

# Interval between notes

Interval is the distance in relation to a scale between two musical
notes (including the extremes) measured in semitones.

Design a function \@intervalo(nota1, nota2, escala)@ that, given two str
\@nota1@ and \@nota2@ that represent the name of two notes, and a list
of lists \@escala@ that contains a chromatic scale where both notes
\@nota1@ and \@nota2@ exist, returns an int with the interval in
semitones from \@nota1@ to \@nota2@.

# Enharmonics

Design a function \@enarmonicas(nota, cromatica)@ that, given a str
\@nota@ with the name of a note, and a list of lists \@cromatica@
containing a chromatic scale in which \@nota@ exists, return a new list
with the names of all its enharmonic notes.

# Diatonica scales

A diatonic scale is a series of 7 notes taken in order out of the total
12 of the chromatic scale starting from a tonic and following a pattern
of diatonic semitone jumps (after a Do there will never be a Do$\sharp$
but Re$\flat$) so that the 7 natural notes are always represented in
order only once each, either in its natural state or altered.

Design a function \@escala_diatonica(tonica, modo, cromatica)@ that,
given a str \@tonica@ with the name of a note, a list of int \@modo@,
and a list of lists \@cromatica@ that contains a chromatic scale in
which \@tonica@ exists, returns a list of 7 str containing the diatonic
scale starting with \@tonica@ following the diatonic semitones jump
pattern indicated by \@modo@.

# Triad chords

A triad chord consists of a set of three different notes that constitute
a harmonic unit and receive the name of the tonic, third and fifth,
because the chord is formed by the notes 0, 2 and 4 of the corresponding
diatonic scale.

Design a function \@acorde_triada(tonica, modo, cromatica)@ that, given
a str \@tonica@ with the name of a note, a int list \@modo@, and a list
of lists \@cromatica@ that contains a chromatic scale in which \@tonica@
exists, returns a list with all three notes of the triad chord taken
from the diatonic scale for \@tonica@ and the diatonic semitones jump
pattern indicated by \@modo@.

## Sample session

## Problem information

Author: InfBesos

Generation: 2026-01-25T15:45:35.674Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
