# Control PRO2 - Torn 1 (Primavera 2018)

Hem decidit estendre la classe `Cjt_estudiants` que heu vist al
laboratori amb dues noves funcionalitats.

La primera funcionalitat calcula la nota global d'un estudiant en una
assignatura a partir de les seves notes en els exàmens parcials
d'aquesta assignatura, i assigna la nota global calculada a aquest
estudiant. La nota global d'un estudiant pot ser $-1$, si es considera
que la qualificació global de l'estudiant en l'assignatura ha de ser NP
(No Presentat), o un valor real en el rang
`[0 … Estudiant::nota_maxima()]`, que correspon a la suma ponderada de
les notes de l'estudiant en els exàmens parcials de l'assignatura. Per
realitzar l'avaluació global dels estudiants d'una assignatura, la
classe `Cjt_estudiants` necessita representar certa informació sobre
aquesta assignatura, en particular el nombre d'exàmens parcials que es
realitzen en l'assignatura i el pes de cada examen parcial en la nota
global de l'assignatura. Per aquest motiu, hem afegit dos atributs nous
a la classe `Cjt_estudiants`: (1) ` nombre_parcials` de tipus enter, que
representa el nombre d'exàmens parcials, i (2) `pesos_parcials` de tipus
` vector`$<$`double`$>$, que permet emmagatzemar els pesos dels
diferents exàmens parcials en la nota global. En particular, el pes de
l'examen parcial $j$-èsim és `pesos_parcials[j-1]` per a tot $j$ en el
rang $1 \le j \le \mbox{nombre\_parcials}$.

Concretament, l'avaluació global d'un estudiant es realitza de la manera
següent. Si la suma dels pesos dels exàmens parcials als quals no s'ha
presentat un estudiant és més gran que 0.5, la nota global de
l'estudiant ha de ser -1 (que és el valor escollit per representar la
qualificació "No Presentat" en la nostra implementació del tipus
`Cjt_estudiants`). En un altre cas, la nota global de l'estudiant ha de
ser la suma ponderada de les seves notes en els exàmens parcials de
l'assignatura, que és igual a la suma de les contribucions a la nota
global dels exàmens parcials als quals l'estudiant s'ha presentat, on la
contribució de l'examen parcial $j$-èsim s'obté multiplicant la nota de
l'estudiant en l'examen parcial $j$-èsim pel pes d'aquest examen
parcial.

Aquesta funcionalitat s'implementa a la classe `Cjt_estudiants`
mitjançant el mètode privat

    void avaluacio_global_iesim(int i); 
    /* Pre:  1 <= i <= mida()
       L'estudiant i-èsim té notes assignades per a tots els exàmens parcials de 
       l'assignatura. La nota de cada examen parcial pot ser -1, si l'estudiant 
       no s'ha presentat a aquest examen parcial, o una nota vàlida en el rang 
       [0...Estudiant::nota_maxima()]. */
    /* Post: L'estudiant i-èsim passa a tenir assignada la seva nota global en 
       l'assignatura, que pot ser -1, si es considera que la seva qualificació 
       global ha de ser NP (No Presentat), o una nota vàlida en el rang 
       [0...Estudiant::nota_maxima()], que correspon a la suma ponderada de les 
       seves notes en els exàmens parcials de l'assignatura als quals s'ha 
       presentat. */

Per exemple, si $c$ és un objecte de la classe `Cjt_estudiants` que
representa els estudiants d'una assignatura amb $5$ exàmens parcials els
pesos dels quals són `[0.1, 0.15, 0.25, 0.25, 0.25]`, respectivament, i
les notes en els exàmens parcials del tercer estudiant de $c$ són
`{6.5, -1, 10, 6, 4 }`, després de la crida
`c.avaluacio_global_iesim(3)`, la nota global del tercer estudiant de
$c$ ha de ser 5.65. De la mateixa manera, si les notes en els exàmens
parcials del cinquè estudiant de $c$ són `{- 1, 10, -1, 5, -1 }`,
després de la crida ` c.avaluacio_global_iesim(5)`, la nota global del
cinquè estudiant de $c$ ha de ser $-1$ (i.e., No Presentat).

La segona funcionalitat afegida a la classe `Cjt_estudiants` calcula i
escriu al canal estàndard de sortida el subconjunt d'exàmens parcials
als quals s'han presentat tots els estudiants que han aprovat
l'assignatura, és a dir, tots els estudiants que tenen una nota global
en l'assignatura més gran o igual que $5$. Aquesta funcionalitat
s'implementa a la classe `Cjt_estudiants` mitjançant el mètode públic

    void parcials_presentats_aprovats() const;
    /* Pre: Tots els estudiants del paràmetre implícit tenen notes assignades per 
       a tots els exàmens parcials i també tenen assignada la seva nota global en 
       l'assignatura. La nota de cada examen parcial pot ser -1, si l'estudiant no 
       s'ha presentat a aquest examen parcial, o una nota vàlida en el rang
       [0...Estudiant::nota_maxima()]. */
    /* Post: Al canal de sortida estàndard s'han escrit els identificadors dels 
       exàmens parcials als quals s'han presentat tots els estudiants que tenen 
       una nota global en l'assignatura més gran o igual a 5. Els identificadors 
       d'aquests exàmens parcials estan ordenats en ordre creixent. */

Per exemple, si $c$ és un objecte de la classe `Cjt_estudiants` que
representa els estudiants d'una assignatura amb $4$ exàmens parcials en
què hi ha exactament $10$ estudiants $\{e_{i_1}, \ldots ,
e_{i_ {10}}\}$ amb una nota global més gran o igual que $5$, i sabem que
d'aquests $10$ estudiants $e_ {i_4}$ no s'ha presentat al primer examen
parcial, i $e_{i_1}$ i $e_{i_6}$ no s'han presentat al tercer examen
parcial, després de la crida ` c.parcials_presentats_aprovats()` es
mostrarà en la pantalla el subconjunt $\{2, 4\}$, ja que els únics
exàmens parcials als quals s'han presentat tots els estudiants aprovats
són el segon i el quart.

Per implementar aquestes funcionalitats hem modificat també la
representació de la classe `Estudiant` de la manera descrita a l'arxiu
`Estudiant.hh`. En particular, representem les notes d'un estudiant en
dos atributs nous: (1) `nota_global` de tipus ` double`, i (2)
`notes_parcials` de tipus `vector`$<$`double`$>$. Concretament, la nota
de l'examen parcial $j$-èsim de l'estudiant paràmetre implícit és
`notes_parcials[j-1]` per a tot $j$ en el rang
$1 \le j \le \mbox{notes\_parcials.size()}$

## Observació

Tenint en compte tot això, heu implementar eficientment el mètode
privat\
`avaluacio_global_iesim` i el mètode públic
` parcials_presentats_aprovats`. Heu de lliurar un arxiu ` solucio.cc`
amb una implementació eficient d'aquests dos mètodes. En el cas del
mètode públic `parcials_presentats_aprovats`, podeu completar la
implementació parcial que us proposem o implementar aquest mètode sense
utilitzar la implementació parcial proposada.

És possible superar alguns jocs de prova (però no tots) **implementant
únicament el mètode privat ` avaluacio_global_iesim`**, sempre que no
modifiqueu la implementació parcial del mètode públic
`parcials_presentats_aprovats` que us proporcionem.

Dins del material addicional de què us proveïm a l'apartat *Public
files* del problema del jutge trobareu l'arxiu `plantilla.txt` amb les
capçaleres de tots dos mètodes i una implementació incompleta del mètode
`parcials_presentats_aprovats`: n'heu de canviar el nom de manera que es
digui `solucio.cc`, completar-lo i lliurar-lo al jutge.

El vostre fitxer `solucio.cc` no pot contenir la implementació d'altres
mètodes de les classes `Estudiant` o `Cjt_estudiants`.

A l'apartat *Public files* del jutge us proveïm de material addicional
en un fitxer .tar. Podeu extreure el contingut d'aquest fitxer amb la
instrucció

       tar -xvf nom_fitxer.tar

Aquest material addicional conté els fitxers següents:

- `plantilla.txt`: és la plantilla del fitxer solucio.cc; heu de canviar
  el nom d'aquest fitxer de manera que es digui `solucio.cc`,
  completar-lo i lliurar-lo al jutge.

- `Cjt_estudiants.hh`: l'especificació Pre/Post de tots els mètodes
  públics i privats d'aquesta nova versió de la classe
  ` Cjt_estudiants`, així com la definició dels atributs privats.

- `Cjt_estudiants.cc`: la implementació de tots els mètodes de la classe
  `Cjt_estudiants`, tret de les dels mètodes que us demanem.

- `Estudiant.hh`: l'especificació de la nova versió de la classe
  `Estudiant` i la definició dels seus atributs privats.

- `Estudiant.cc`: la implementació de tots els mètodes de la classe
  `Estudiant`.

- `pro2.cc`: un programa principal que podeu fer servir per provar els
  mètodes públics d'aquesta nova versió de la classe ` Cjt_estudiants`.

- `entrada.txt` i `sortida_correcta.txt`: fitxer d'entrada del joc de
  proves públic i sortida correcta per a aquest joc.

- `llegeixme.txt`: instruccions per generar l'executable del programa
  `pro2.cc` i provar-lo.

Valorarem positivament que la solució no contingui instruccions
innecessàries (especialment bucles o crides a operacions costoses), ni
objectes innecessaris (especialment vectors o matrius); que no faci
recorreguts quan hauria de fer cerques, i que usi correctament les
operacions més adients de les classes `Estudiant` i ` Cjt_estudiants`,
sempre que sigui possible. No es pot usar cap estructura de dades que no
hagi aparegut a les sessions 1 a 4 de laboratori.

Quan feu els enviaments, el jutge us indicarà quants jocs de proves
supera el vostre programa i de quin tipus (públic o privat). **Tingueu
en compte que és possible superar alguns jocs de prova (però no tots)
implementant únicament el mètode `avaluacio_global_iesim`, si no
modifiqueu la implementació parcial del mètode
` parcials_presentats_aprovats` que us proporcionem**.

## Informació del problema

Autoria: Professors de PRO2

Generació: 2026-01-25T15:31:27.107Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
