# Pila màxima

Implementeu una funció **RECURSIVA** que, donades dues piles d'enters
positius, obté una nova pila que conté, per a cada posició, el màxim
dels valors de les piles de partida en les mateixes corresponents
posicions. En cas que una de les piles no tingui un valor definit en una
posició, s'agafa el valor de l'altra pila. Aquesta és la capcelera:

    // Pre: Rep dues piles d'enters positius s1 i s2.
    // Post: Retorna una pila, on al seu fons hi ha el màxim dels fons de s1,s2, després,
    // en segon lloc començant des del fons, el màxim dels segons llocs de s1,s2 començant des del fons,
    // i així successivament.
    // Quan una de les dues piles no té valors definits en alguna posició, la pila resultant hi té
    // el valor de l'altra pila en aquella posició.

    stack<int> maximumStack(stack<int> s1,stack<int> s2);

Aquí tenim un exemple de comportament de la funció, a on es mostren els
elements de les piles des del primer afegit a l'esquerra de tot (fons de
la pila), a l'últim afegit a la dreta de tot (top de la pila):

    1 4 6 4 2
    5 8 7 1 1 3 6 5 6
    =>
    5 8 7 4 2 3 6 5 6

## Observació

Només cal enviar el procediment demanat; el programa principal serà
ignorat.

## Observació

La vostra funció i subfuncions que creeu han de treballar només amb
piles. Heu de trobar una solució **RECURSIVA** i eficient del problema.
En particular, no hi hauria d'haver cap bucle en cap de les funcions que
implementeu. Si creeu funcions auxiliars, afegiu-hi les seves PRE/POST.
En les crides recursives, incloeu la hipòtesi d'inducció, és a dir una
explicació del que es cumpleix després de la crida, i també la funció de
fita/decreixement o una justificació de perquè la funció recursiva
acaba.

Una solució directa superarà els jocs de proves públics i us permetrà
obtenir una nota raonable. Però molt possiblement serà lenta, i
necessitareu crear alguna funció recursiva auxiliar per a produïr una
solució més eficient capaç de superar tots els jocs de proves.

Avaluació sobre 10 punts:

- Solució lenta: 7 punts.

- Solució lenta + justificació: 8 punts.

- solució ràpida: 9 punts.

- solució ràpida + justificació: 10 punts.

Entenem com a solució lenta una que és correcta i capaç de superar els
jocs de proves públics. Entenem com a solució ràpida una que és correcta
i capaç de superar els jocs de proves públics i privats. La justificació
val 1 punt i consisteix en definir correctament les PRE/POST de les
funcions auxiliars que afegiu i en definir correctament les hipòtesis
d'inducció i funcions de fita.

## Informació del problema

Autoria: PRO1-Vilanova

Generació: 2026-01-25T15:27:36.529Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
