# Graf dirigit amb matriu d'adjacència. Quants vèrtexs diferents es poden visitar des de cada vèrtex

Donada la classe $graf$ que permet gestionar grafs dirigits i no
etiquetats amb $n$ vèrtexs (els vèrtexs són enters dins l'interval
$[0, n-1]$), cal implementar el mètode

      vector<nat> quants_vertexs_es_visiten() const;
      // Pre:  Cert
      // Post: Retorna quants vèrtexs diferents es poden visitar (hi ha un camí)
      //       des de cada vèrtex del graf, incloent a ell mateix.

Les arestes es guarden en una matriu d'adjacència. Un dels jocs de prova
públics és aquest graf que conté 5 vèrtexs (mira el PDF de l'enunciat):

<figure data-latex-placement="h">
<img src="graf.png" />
</figure>

el qual donaria com a resultat el vector 5 2 5 1 5, indicant que hi ha 5
vèrtexs diferents que es poden visitar des del vèrtex 0 (tots els
vèrtexs), hi ha 2 des del vèrtex 1 (el 1 i el 3), hi ha 5 des del vèrtex
2 (tots), hi ha 1 des del vèrtex 3 (només el 3) i hi ha 5 des del vèrtex
4 (tots).

Cal enviar a jutge.org la següent especificació de la classe $graf$ i la
implementació del mètode dins del mateix fitxer (la resta de mètodes
públics ja estan implementats). Indica dins d'un comentari a la
capçalera del mètode el seu cost en funció del nombre de vèrtexs $n$ i
el nombre d'arestes $m$ del graf.

    #include <vector>
    using namespace std;
    typedef unsigned int nat;

    class graf {
      // Graf dirigit i no etiquetat.
      // Les arestes es guarden en una matriu d'adjacència.
      public:
        // Constructora per defecte. Crea un graf buit.
        graf();

        // Destructora
        ~graf();

        // Llegeix les dades del graf del canal d'entrada
        void llegeix();

        vector<nat> quants_vertexs_es_visiten() const;
        // Pre: Cert
        // Post: Retorna quants vèrtexs diferents es poden visitar (hi ha un camí)
        //       des de cada vèrtex del graf, incloent a ell mateix.

      private:
        nat n; // Nombre de vèrtexs
        nat m; // Nombre d'arestes
        vector<vector<bool> > a; // Matriu d'adjacència

        // Aquí va l'especificació dels mètodes privats addicionals

    };

    // Aquí va la implementació del mètode públic quants\_vertexs\_es\_visiten i privats addicionals

Degut a que jutge.org només permet l'enviament d'un fitxer amb la
solució del problema, en el mateix fitxer hi ha d'haver l'especificació
de la classe i la implementació del mètode
$quants\_vertexs\_es\_visiten$ (el que normalment estarien separats en
els fitxers $.hpp$ i $.cpp$).

Per testejar la classe disposes d'un programa principal que llegeix un
graf i després crida el mètode $quants\_vertexs\_es\_visiten$.

## Entrada

L'entrada conté un graf: el nombre de vèrtexs, el nombre d'arestes i una
llista d'arestes. Cada aresta s'indica pels dos vèrtexs que relaciona.

## Sortida

Escriu una línia amb el nombre de vèrtexs diferents que es poden visitar
des de cada vèrtex del graf separats per espais.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$quants\_vertexs\_es\_visiten$. Pots ampliar la classe amb mètodes
privats. Segueix estrictament la definició de la classe de l'enunciat.

Indica dins d'un comentari a la capçalera del mètode el seu cost en
funció del nombre de vèrtexs $n$ i el nombre d'arestes $m$ del graf.

## Informació del problema

Autoria: Jordi Esteve

Generació: 2026-01-25T15:25:05.431Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
