# Entropia

Feu la funció `entropia(V)` tal que, donat un vector `V`, que conté
nombres naturals, en torni l'entropia de Shannon.

L'entropia de Shannon per a un **conjunt** $\mathcal{X}$ es calcula amb
la fórmula:

$$\begin{equation}
H(X) = -\sum_{x \in \mathcal{X}} p(x) \log_b p(x).
\end{equation}$$

En el nostre cas, substitïm la probabilitat $p(x)$ d'un element
$x \in \mathcal{X}$ per la **freqüència** dins del vector `v`. D'aquesta
manera, la fórmula que cal calcular és:

$$\begin{equation}
H(X) = -\sum_{x \in 1:N} \frac{freq(x,v)}{N} \log_2 (\frac{freq(x,v)}{N}).
\end{equation}$$

on $freq(x,v)$ és la freqüència del nombre `x` al vector `V`.

Per a calcular el logaritme en base 2 en `python` podeu fer servir la
funció `math.log2(x)`. Abans, però, caldrà que afegiu `import math` a la
vostra solució.

## Entrada

Un vector `V` de naturals.

## Sortida

L'entropia de Shannon de `V`.

## Informació del problema

Autoria: Jaume Baixeries

Generació: 2026-01-25T18:51:43.731Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
