# Practica de PRO2 - Otoño 2019 - entrega intermedia

Este problema corresponde a la entrega intermedia de la práctica. Tened
en cuenta que:

- Esta no es la entrega definitiva de la práctica completa, ni siquiera
  es una entrega provisional de la práctica completa.

- En esta entrega se ha de proporcionar todo el código necesario
  (clases, programa principal y Makefile) para poder usar todas las
  funcionalidades de la práctica, excepto las consultas por rango de
  fechas (`busca_por_fecha`), por etiqueta (`busca_por_etiqueta`) y las
  consultas booleanas (`evalua_consulta_booleana`).

- En esta entrega no pedimos carpetas generadas mediante `doxygen`, pero
  los ficheros de la clases pueden llevar todos los comentarios
  ` doxygen` que queráis; de hecho recomendamos que incluyáis las
  especificaciones de todas las operaciones y que sean lo más
  definitivas posible.

- Esta entrega no tendrá nota manual.

## Entrada

Una secuencia de instrucciones y datos que siguen el formato del
enunciado de la práctica y del juego de pruebas público.

## Salida

Una secuencia de resultados que siguen el formato del enunciado de la
práctica y del juego de pruebas público.

## Observación

El Jutge prueba vuestras entregas mediante 4 juegos de pruebas:

- sample: el juego de pruebas público

- privat1: juego de pruebas que ensaya principalmente las
  funcionalidades sobre el álbum en curso (funciones 1--5)

- privat2: juego de pruebas que hace énfasis en las funcionalidades de
  gestión y consulta de álbumes en la colección (funciones 6--10)

- privat3: juego de pruebas que hace énfasis en las funcionalidades de
  gestión y consulta de fotos en la colección (funciones 11--14)

En un fichero llamado `practica.tar` tenéis que entregar

- Los ficheros .hh y .cc de las clases y el programa principal

- El fichero Makefile, que usaremos para generar y probar el ejecutable

Tened en cuenta las siguientes restricciones:

- El fichero que contiene el programa principal se ha de llamar
  `program.cc`

- El Makefile ha de generar un ejecutable llamado `program.exe`

- Es importante que uséis las opciones de compilación del Jutge de PRO2
  (ved Documentation $\rightarrow$ Compilers $\rightarrow$ PRO2 a
  www.jutge.org)

- No usar la opción `-D_GLIBCXX_DEBUG` o usarla de forma incorrecta
  podrá ser penalizado

Producid el fichero `practica.tar` con la instrucción Linux

    tar -cvf practica.tar fitxer1 fitxer2 fitxer3 ...

desde el directorio/carpeta donde tengáis los ficheros que vais a
entregar. Incluid esta instrucción en vuestro Makefile, de forma que el
`.tar` se pueda generar ejecutando `make practica.tar`. Con eso
reduciréis el riesgo de error en sucesivas entregas. El Jutge no acepta
`.tar` donde los ficheros estén dentro de carpetas. Recomendamos usar
`GNU tar` para reducir el riesgo de que el fichero `practica.tar` sea
incompatible con el Jutge. No es necesario incluir `BinTree.hh` en
`practica.tar`.

## Información del problema

Autoría: PR02

Generación: 2026-01-25T21:09:51.963Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
