# 4-bit ALU

Design a small ALU that receives two input numbers, `a` and `b`, and
produces the result of an operation encoded by the signals `op`. There
are four operations: addition ($a+b$, when `op`=00), subtraction ($a-b$,
when `op`=01), transfer `a` ($a$, when `op`=10) and double `a` ($2a$,
when `op`=11). The ALU also has an additional output (`zero`) that is
activated when the result is zero.

Design the ALU for 4-bit operands.

## Specification

``` verilog
module ALU(a, b, op, result, zero);
    input [3:0] a, b;
    input [1:0] op;
    output [3:0] result;
    output zero;
```

## Input

- `a` and `b` are the two input 4-bit operands.

- `op` indicates the type of operation.

## Output

- `result` is the 4-bit result of the operation.

- `zero` indicates when the result is zero.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:14:12.291Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
