#include <iostream>
#include <string>
#include "CryptoApp.hpp"

using namespace std;


// PRE: cert (no hi ha cap precondició)
// POST: Mostra per pantalla el menú d'opcions disponibles del programa
void mostrarMenu() {
    cout << "========================================" << endl;
    cout << "   Gestor de Carteres Cripto - CLI" << endl;
    cout << "========================================" << endl;
    cout << endl;
    cout << "Seleccioneu una opcio:" << endl;
    cout << endl;
    cout << endl;
    cout << "1.  crearActiu          - Donar d'alta un nou actiu" << endl;
    cout << "2.  crearPreu           - Afegir un preu diari a un actiu" << endl;
    cout << "3.  mostrarActius       - Llistar tots els actius" << endl;
    cout << "4.  mostrarPreusActiu   - Mostrar tots els preus d'un actiu" << endl;
    cout << endl;
    cout << "5.  crearUsuari         - Donar d'alta un nou usuari" << endl;
    cout << "6.  mostrarUsuaris      - Llistar tots els usuaris" << endl;
    cout << "7.  crearAdreca         - Afegir una nova adreça de wallet" << endl;
    cout << "8.  mostrarAdrecesUsuari - Mostrar totes les adreces d'un usuari" << endl;
    cout << endl;
    cout << "9.  afegirEuros         - Afegir Euros al saldo d'un usuari" << endl;
    cout << "10. retirarEuros        - Retirar Euros del saldo d'un usuari" << endl;
    cout << endl;
    cout << "11. comprar             - Comprar un actiu per a un usuari" << endl;
    cout << "12. vendre              - Vendre un actiu d'un usuari" << endl;
    cout << "13. preuActualActiu     - Consultar l'ultim preu d'un actiu" << endl;
    cout << "14. carteraDeUsuari     - consultar la cartera i el guany total d'un usuari" << endl;
    cout << endl;
    cout << "15. eliminarUsuari      - Eliminar un usuari i les seves dades" << endl; // NOU
    cout << endl;
    cout << "0.  acabar              - Sortir del programa" << endl;
    cout << endl;
    cout << "----------------------------------------" << endl;
    cout << "Introduiu l'opcio desitjada: ";
}


// PRE: str es un string
// POST: retorna true si str representa un numero vàlid
bool isValidNumber(const string& str) {
	
	bool isValid = true;
    if (str.empty()) {
		isValid = false;
    }
    
    bool hasDecimal = false;
    
    unsigned int i = 0;
    
	while (isValid == true and i < str.size()) {
		if (str[i] == '.') {
			if (hasDecimal == true) {
				isValid = false;
			}
			else {
				hasDecimal = true;
			}
		}
		else if (str[i] < '0' or str[i] > '9') {
			isValid = false;
		}
		
		++i;
	}
    
    return isValid;
}


// PRE: str es un string que representa un número
// POST: retorna el valor double correspondent per result
double stringToDouble(const string& str) {
    double result = 0.0;
    double decimal = 0.0;
    bool negative = false;
    bool decimalPart = false;
    double divisor = 10.0;
    
    unsigned int startIndex;
   
    if (str[0] == '-') {
        negative = true;
        startIndex = 1;
    }
    else {
		startIndex = 0;
	}
    
    for (unsigned int i=startIndex; i < str.size(); i++) {
        if (str[i] == '.') {
            decimalPart = true;
        } 
        else if (str[i] >= '0' and str[i] <= '9') {
            if (!decimalPart) {
                result = result * 10.0 + (str[i] - '0');
            } 
            else {
                decimal += (str[i] - '0') / divisor;
                divisor *= 10.0;
            }
        }
    }
    
    result += decimal;
    
    if (negative) {
        result = -result;
    }
    
    return result;
}


// PRE: str es un string que representa un número enter
// POST: retorna el valor int correspondent per result
int stringToInt(const string& str) {
    int result = 0;
    bool negative = false;
    unsigned int startIndex;
    
    if (str[0] == '-') {
        negative = true;
        startIndex = 1;
    }
    else {
		startIndex = 0;
    }
    
    for (unsigned int i=startIndex; i < str.size(); i++) {
        if (str[i] >= '0' and str[i] <= '9') {
            result = result * 10 + (str[i] - '0');
        }
    }
    
    if (negative) {
        result = -result;
    }
    
    return result;
}


// Funció auxiliar per comptar holdings d'un usuari (per al driver)
// PRE: app està inicialitzada, userId és un enter qualsevol.
// POST: Retorna el nombre d'elements a vec_holdings que tenen el userId donat.
//       Retorna 0 si l'usuari no té holdings o no existeix.
int countHoldingsOfUser(const CryptoApp& app, int userId) {
    int count = 0;
    const vector<Holding>& holdings = app.getHoldings(); 
    for (unsigned int i = 0; i < holdings.size(); ++i) {
        if (holdings[i].getUserId() == userId) {
            count++;
        }
    }
    return count;
}


int main() {
    CryptoApp app;
    string command;
    
    mostrarMenu();
    
    bool acabat = false;
    
    while (!acabat and cin >> command) {
        try {
            // 1. Crear Actiu
            if (command == "crearActiu") {
                string assetSymbol, name, decimals;                
                cin >> assetSymbol >> name >> decimals;
                
                if (!isValidNumber(decimals)) {
					cout << "Error al crear Actiu " << assetSymbol << ". Decimals en format incorrecte" << endl;
				}
				else {
				
					int dec = stringToInt(decimals);
				
					try {
						app.createAsset(assetSymbol, name, dec);
						cout << "Actiu " << assetSymbol << " creat correctament" << endl;
					} catch (const exception& e) {
						string errorMsg = e.what();
						cout << errorMsg << endl;
					}
				}
            }
            // 2. Crear Preu
            else if (command == "crearPreu") {
                string assetSymbol, dateISO;
                double price;
                string priceStr;
                
                cin >> assetSymbol >> dateISO >> priceStr;
                
                if (!isValidNumber(priceStr)) {
					cout << "Error al crear Preu de " << assetSymbol << " a " << dateISO << ". El preu està en format incorrecte" << endl;
                }
                
                else {
				
					price = stringToDouble(priceStr);
                
					try {
						app.createPrice(assetSymbol, dateISO, price);
						cout << "Preu de " << assetSymbol << " a " << dateISO << " creat correctament" << endl;
					} catch (const exception& e) {
						string errorMsg = e.what();
						cout << errorMsg << endl;
					}
				}
            }
            // 3. Mostrar Actius
            else if (command == "mostrarActius") {
                app.listAssets();
            }
            // 4. Mostrar Preus d'un actiu
            else if (command == "mostrarPreusActiu") {
                string assetSymbol;
                cin >> assetSymbol;
                
                try {
                    app.listPricesOfAsset(assetSymbol);
                } catch (const exception& e) {
                    string errorMsg = e.what();
					cout << errorMsg << endl;
                }
            }
            // 5. Crear Usuari
            else if (command == "crearUsuari") {
                string name, email, password;
                
                cin >> name >> email >> password;
                
                try {
                    app.createUser(name, email, password);
                    cout << "Usuari " << name << " creat correctament" << endl;
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 6. Crear Adreça
            else if (command == "crearAdreca") {
                string userName, assetSymbol, address, label;
                
                cin >> userName >> assetSymbol >> address;

                getline(cin, label);
                
                if (!label.empty() and label[0] == ' ') {
					label.erase(0, 1);
				}
                if (!label.empty() and label[0] == '"') {
                    label.erase(0, 1);
                }
                if (!label.empty() and label[label.size()-1] == '"') {
                    label.erase(label.size()-1, 1);
                }
                
                try {
                    app.createAddress(userName, assetSymbol, address, label);
                    cout << "Adreça afegida a " << userName << endl;
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 7. Mostrar Usuaris
            else if (command == "mostrarUsuaris") {
                app.listUsers();
            }
            // 8. Afegir Euros
            else if (command == "afegirEuros") {
                string userName;
                string quantityStr;
                double quantity;
                
                cin >> userName >> quantityStr;
                quantity = stringToDouble(quantityStr);
                
                try {
                    app.addEuros(userName, quantity);
                    cout << quantityStr << " Euros afegits correctament a l'usuari " << userName << endl;
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 9. Retirar Euros
            else if (command == "retirarEuros") {
                string userName;
                string quantityStr;
                double quantity;
                
                cin >> userName >> quantityStr;
                quantity = stringToDouble(quantityStr);
                
                try {
                    app.withdrawEuros(userName, quantity);
                    
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 10. Mostrar Adreces d'Usuari
            else if (command == "mostrarAdrecesUsuari") {
                string userName;
                cin >> userName;
                
                try {
                    app.listAddressesOfUser(userName);
                    
                } catch (const exception& e) {
                    cout << "Error al mostrar Adreces. Usuari " << userName << " no existeix" << endl;
                }
            }
            // 11. Comprar
            else if (command == "comprar") {
                string userName, assetSymbol;
                string quantityStr;
                double quantity;
                
                cin >> userName >> assetSymbol >> quantityStr;
                quantity = stringToDouble(quantityStr);
                
                try {
                    app.buy(userName, assetSymbol, quantity);
                    cout << "Compra de " << quantityStr << " unitats registrada per " << userName << " en " << assetSymbol << endl;
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 12. Vendre
            else if (command == "vendre") {
                string userName, assetSymbol;
                string quantityStr;
                double quantity;
                
                cin >> userName >> assetSymbol >> quantityStr;
                quantity = stringToDouble(quantityStr);
                
                try {
                    app.sell(userName, assetSymbol, quantity);
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 13. Mostrar Preu actual d'un actiu
            else if (command == "preuActualActiu") {
                string assetSymbol;
                cin >> assetSymbol;
                
                try {
                    app.showCurrentPrice(assetSymbol);
                    
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            }
            // 14. Mostrar Cartera d'Usuari
            else if (command == "carteraDeUsuari") {
                string userName;
                cin >> userName;
                
                try {
                    app.evaluatePortfolio(userName);
                } catch (const exception& e) {
                    cout << "Error al mostrar tenencies per l'usuari: " << userName << endl;
                }
            }
            // 15. Eliminar Usuari
           /*  else if (command == "eliminarUsuari") {
                string name;
                cin >> name;
                try {
                    app.deleteUser(name);
                } catch (const exception& e) {
                    string errorMsg = e.what();
                    cout << errorMsg << endl;
                }
            } */

           // 15. Eliminar Usuari (Versió JUTGE: Validació sense excepcions)
            else if (command == "eliminarUsuari") {
                string name;
                cin >> name;
                
                // PAS 1: ABANS
                int userId = app.findUserIdByNamePublic(name);
                int userExistsBefore = 0;
                int holdingsBefore = 0;
                
                if (userId != -1) {
                    userExistsBefore = 1;
                    holdingsBefore = countHoldingsOfUser(app, userId);
                }
                
                // Imprimim estat inicial
                cout << userExistsBefore << " " << holdingsBefore << endl;
                
                // PAS 2: EXECUTAR (Ara sense try-catch)
                app.deleteUser(name);
                
                // PAS 3: DESPRÉS
                int userExistsAfter = 0;
                int holdingsAfter = 0;
                
                // Verifiquem estat final
                int userIdAfter = app.findUserIdByNamePublic(name);
                
                if (userIdAfter != -1) {
                    userExistsAfter = 1;
                    holdingsAfter = countHoldingsOfUser(app, userIdAfter);
                } else {
                    if (userId != -1) {
                        holdingsAfter = countHoldingsOfUser(app, userId);
                    }
                }
                
                cout << userExistsAfter << " " << holdingsAfter << endl;
            }
            // 16. Acabar
            else if (command == "acabar") {
                acabat = true;
            }
            // Comando desconocido
            else {
                cout << "Comanda desconeguda: " << command << endl;
            }
            
        } catch (const exception& e) {
            cout << "Error general: " << e.what() << endl;
        }
    }
    
    return 0;
}

