#ifndef USER_HPP
#define USER_HPP

#include <string>
#include <vector>
#include "Address.hpp"

using namespace std;

class User {
private:
    static int nextId;
    int id;
    string name;
    string email;
    string password;
    vector<Address> vec_addresses;

public:
    // Constructor
    // PRE: name no buit, email vàlid amb @
    // POST: Crea un User amb els paràmetres donats
    User(const string& name, const string& email, const string& password);
    
    // Destructor
    // PRE: cert
    // POST: Elimina els recursos de User
    ~User();
    
    // Consultors
    
    // PRE: cert
    // POST: Retorna l'id de l'usuari
    int getId() const;
    
    // PRE: cert
    // POST: Retorna el nom de l'usuari
    string getName() const;
    
    // PRE: cert
    // POST: Retorna l'email de l'usuari
    string getEmail() const;
    
    // PRE: cert
    // POST: Retorna la contrasenya de l'usuari
    string getPassword() const;
    
    // PRE: cert
    // POST: Retorna el vector d'adreces de l'usuari
    const vector<Address>& getAddresses() const;
    
    // Modificadors
    
    // PRE: Address vàlida
    // POST: Afegeix una adreça al vector d'adreces
    void addAddress(const Address& address);
    
    // PRE: assetSymbol i address no buits
    // POST: Retorna true si l'usuari ja té aquesta adreça per aquest actiu
    bool hasAddress(const string& assetSymbol, const string& address) const;
    
    // Operacions d'escriptura
    
    // PRE: cert
    // POST: Visualitza les dades del p.i.
    friend ostream& operator<<(ostream& os, const User& user);
};

#endif
