#include "User.hpp"
#include <iostream>
#include <stdexcept>

using namespace std;

int User::nextId = 1;

// Constructor
// PRE: name no buit, email vàlid amb @
// POST: Crea un User amb els paràmetres donats
User::User(const string& name, const string& email, const string& password) {
    
    if (name.size() > 50) {
        throw runtime_error("Error al crear Usuari. Nom > 50 caràcters");
    }

    if (password.size() > 50) {
        throw runtime_error("Error al crear Usuari. Contrasenya > 50 caracters");
    }
    
    this->id = nextId++;
    this->name = name;
    this->email = email;
    this->password = password;
}

// Destructor
// PRE: cert
// POST: Elimina els recursos de User
User::~User() {
}

// Consultors

// PRE: cert
// POST: Retorna l'id de l'usuari
int User::getId() const {
    return id;
}

// PRE: cert
// POST: Retorna el nom de l'usuari
string User::getName() const {
    return name;
}

// PRE: cert
// POST: Retorna l'email de l'usuari
string User::getEmail() const {
    return email;
}

// PRE: cert
// POST: Retorna la contrasenya de l'usuari
string User::getPassword() const {
    return password;
}

// PRE: cert
// POST: Retorna el vector d'adreces de l'usuari
const vector<Address>& User::getAddresses() const {
    return vec_addresses;
}

// Modificadors

// PRE: Address vàlida
// POST: Afegeix una adreça al vector d'adreces
void User::addAddress(const Address& address) {
    vec_addresses.push_back(address);
}

// PRE: assetSymbol i address no buits
// POST: Retorna true si l'usuari ja té aquesta adreça per aquest actiu
bool User::hasAddress(const string& assetSymbol, const string& address) const {
    
    bool hassAddress;
	bool found = false;
	unsigned int i = 0;
	// Invariant: i < vec_addresses.size() i si found == false implica que (assetSymbol, address) no està en vec_addresses[0..i-1]
	while (found == false and i<vec_addresses.size()) {
		if (vec_addresses[i].getAssetSymbol() == assetSymbol and vec_addresses[i].getAddress() == address) {
			hassAddress = true;
			found = true;
		}
		else {
			++i;
		}
	}
	
	if (found == false) {
		hassAddress = false;
	}
	return hassAddress;
}

// Operacions d'escriptura

// PRE: cert
// POST: Visualitza les dades del p.i.
ostream& operator<<(ostream& os, const User& user) {
    os << user.name << " - " << user.email;
    return os;
}
