#ifndef PRICE_HPP
#define PRICE_HPP

#include <string>
#include <iostream>

using namespace std;

class Price {
private:
    int id;
    int assetId;
    string dateISO;
    double price;
    
    static int nextId;

public:
    // Constructor

    // PRE: assetId vàlid, dataISO en format YYYY-MM-DD, price > 0
    // POST: Crea un Price amb els paràmetres donats
    Price(int assetId, const string& dataISO, double price);
    
    // Destructor

    //PRE: cert
    //POST: Elimina el preu
    ~Price();
    
    // Consultors

    // PRE: cert
    // POST: retorna l'id del preu
    int getId() const;
    
    // PRE: cert
    // POST: retorna l'id de l'actiu
    int getAssetId() const;
    
    // PRE: cert
    // POST: retorna la data en format ISO
    string getDateISO() const;
    
    // PRE: cert
    // POST: retorna el preu
    double getPrice() const;
	
    //Operacions escriptura

    //PRE: cert
    //POST: visualitza les dades del p.i.
    friend ostream& operator<<(ostream &os, const Price &p);
    
};

#endif 
