#include "Price.hpp"
#include <stdexcept>
#include <iostream>

using namespace std;

int Price::nextId = 1;

// Constructor

// PRE: assetId vàlid, dataISO en format YYYY-MM-DD, price > 0
// POST: Crea un Price amb els paràmetres donats
Price::Price(int assetId, const string& date, double priceValue) {
    
    this->id = nextId++;
    this->assetId = assetId;
    this->dateISO = date;
    this->price = priceValue;
}

// Destructor

//PRE: cert
//POST: Elimina el preu
Price::~Price() {
    
}

// Consultors

// PRE: cert
// POST: retorna l'id del preu
int Price::getId() const {
    return id;
}

// PRE: cert
// POST: retorna l'id de l'actiu
int Price::getAssetId() const {
    return assetId;
}

// PRE: cert
// POST: retorna la data en format ISO
string Price::getDateISO() const {
    return dateISO;
}

// PRE: cert
// POST: retorna el preu
double Price::getPrice() const {
    return price;
}

//Operacions escriptura

//PRE: cert
//POST: visualitza les dades del p.i.
ostream& operator<<(ostream& os, const Price& p) {
    os << p.dateISO << " " << p.price; //sin endl;
    return os;
}
